/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.util.Base64;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.auth.impl.AuthProviderInternal;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;

public class BasicAuthHandlerImpl
extends AuthorizationAuthHandler {
    private static AuthProvider verifyProvider(AuthProvider provider) {
        if (provider instanceof AuthProviderInternal) {
            ((AuthProviderInternal)provider).verifyIsUsingPassword();
        }
        return provider;
    }

    public BasicAuthHandlerImpl(AuthProvider authProvider, String realm) {
        super(BasicAuthHandlerImpl.verifyProvider(authProvider), realm, AuthorizationAuthHandler.Type.BASIC);
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        this.parseAuthorization(context, false, parseAuthorization -> {
            String spass;
            String suser;
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            try {
                String decoded = new String(Base64.getDecoder().decode((String)parseAuthorization.result()));
                int colonIdx = decoded.indexOf(":");
                if (colonIdx != -1) {
                    suser = decoded.substring(0, colonIdx);
                    spass = decoded.substring(colonIdx + 1);
                } else {
                    suser = decoded;
                    spass = null;
                }
            }
            catch (RuntimeException e) {
                context.fail(e);
                return;
            }
            handler.handle(Future.succeededFuture(new JsonObject().put("username", suser).put("password", spass)));
        });
    }

    @Override
    protected String authenticateHeader(RoutingContext context) {
        return "Basic realm=\"" + this.realm + "\"";
    }
}

