/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.SvgString;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.Line;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.security.ImageIO;
import znaishaded.net.sourceforge.plantuml.ugraphic.AffineTransformType;
import znaishaded.net.sourceforge.plantuml.ugraphic.PixelImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImageSvg;

public class EmbeddedDiagram
implements CharSequence {
    private final Display system;

    public EmbeddedDiagram(Display system) {
        this.system = system;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public Draw asDraw(ISkinSimple skinParam) {
        return new Draw(skinParam);
    }

    public class Draw
    extends AbstractTextBlock
    implements Line,
    Atom {
        private BufferedImage image;
        private final ISkinSimple skinParam;

        @Override
        public List<Atom> splitInTwo(StringBounder stringBounder, double width) {
            throw new UnsupportedOperationException(this.getClass().toString());
        }

        private Draw(ISkinSimple skinParam) {
            this.skinParam = skinParam;
        }

        @Override
        public double getStartingAltitude(StringBounder stringBounder) {
            return 0.0;
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            try {
                BufferedImage im = this.getImage();
                return new Dimension2DDouble(im.getWidth(), im.getHeight());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return new Dimension2DDouble(42.0, 42.0);
        }

        @Override
        public void drawU(UGraphic ug) {
            try {
                boolean isSvg = ug.matchesProperty("SVG");
                if (isSvg) {
                    String imageSvg = this.getImageSvg();
                    SvgString svg = new SvgString(imageSvg, 1.0);
                    ug.draw(new UImageSvg(svg));
                    return;
                }
                BufferedImage im = this.getImage();
                UImage image = new UImage(new PixelImage(im, AffineTransformType.TYPE_BILINEAR));
                ug.draw(image);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private String getImageSvg() throws IOException, InterruptedException {
            Diagram system = this.getSystem();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            system.exportDiagram(os, 0, new FileFormatOption(FileFormat.SVG));
            os.close();
            return new String(os.toByteArray());
        }

        private BufferedImage getImage() throws IOException, InterruptedException {
            if (this.image == null) {
                boolean sav = SkinParam.USE_STYLES();
                this.image = this.getImageSlow();
                SkinParam.setBetaStyle(sav);
            }
            return this.image;
        }

        private BufferedImage getImageSlow() throws IOException, InterruptedException {
            Diagram system = this.getSystem();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            system.exportDiagram(os, 0, new FileFormatOption(FileFormat.PNG));
            os.close();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            BufferedImage im = ImageIO.read(is);
            is.close();
            return im;
        }

        @Override
        public HorizontalAlignment getHorizontalAlignment() {
            return HorizontalAlignment.LEFT;
        }

        private Diagram getSystem() throws IOException, InterruptedException {
            BlockUml blockUml = new BlockUml(EmbeddedDiagram.this.system.as2(), Defines.createEmpty(), this.skinParam, null);
            return blockUml.getDiagram();
        }
    }
}

