/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CommandMultilinesHeader
extends CommandMultilines<TitledDiagram> {
    public CommandMultilinesHeader() {
        super("(?i)^(?:(left|right|center)?[%s]*)header$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?header$";
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines) {
        lines = lines.trim();
        Matcher2 m3 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        String align = m3.group(1);
        Display strings = (lines = lines.subExtract(1, 1)).toDisplay();
        if (strings.size() > 0) {
            HorizontalAlignment ha = HorizontalAlignment.fromString(align, HorizontalAlignment.RIGHT);
            if (SkinParam.USE_STYLES() && align == null) {
                ha = FontParam.HEADER.getStyleDefinition(null).getMergedStyle(((UmlDiagram)diagram).getSkinParam().getCurrentStyleBuilder()).getHorizontalAlignment();
            }
            diagram.getHeader().putDisplay(strings, ha);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty header");
    }
}

