/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleSizeChange
implements Command {
    private final Pattern2 pattern;

    public static Command create() {
        return new CommandCreoleSizeChange("^(?i)(\\<size[\\s:]+(\\d+)[%s]*\\>(.*?)\\</size\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleSizeChange("^(?i)(\\<size[\\s:]+(\\d+)[%s]*\\>(.*)$)");
    }

    private CommandCreoleSizeChange(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(2).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        int size = Integer.parseInt(m3.group(2));
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeSize(size);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m3.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m3.group(1).length());
    }
}

