/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupRoot;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.svek.GroupPngMakerState;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;

public final class CucaDiagramSimplifierState {
    private final CucaDiagram diagram;
    private final StringBounder stringBounder;

    public CucaDiagramSimplifierState(CucaDiagram diagram, List<String> dotStrings, StringBounder stringBounder) throws IOException, InterruptedException {
        boolean changed;
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        do {
            changed = false;
            Collection<IGroup> groups = this.getOrdered(diagram.getRootGroup());
            for (IGroup g2 : groups) {
                if (!diagram.isAutarkic(g2)) continue;
                IEntityImage img = this.computeImage(g2);
                g2.overrideImage(img, g2.getGroupType() == GroupType.CONCURRENT_STATE ? LeafType.STATE_CONCURRENT : LeafType.STATE);
                changed = true;
            }
        } while (changed);
    }

    private Collection<IGroup> getOrdered(IGroup root) {
        LinkedHashSet<IGroup> ordered = new LinkedHashSet<IGroup>();
        ordered.add(root);
        int size = 1;
        do {
            size = ordered.size();
            this.addOneLevel(ordered);
        } while (size != ordered.size());
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup g2 : ordered) {
            if (g2 instanceof GroupRoot) continue;
            result.add(0, g2);
        }
        return result;
    }

    private void addOneLevel(Collection<IGroup> currents) {
        for (IGroup g2 : new ArrayList<IGroup>(currents)) {
            for (IGroup child : this.reverse(g2.getChildren())) {
                currents.add(child);
            }
        }
    }

    private List<IGroup> reverse(Collection<IGroup> source) {
        ArrayList<IGroup> result = new ArrayList<IGroup>();
        for (IGroup g2 : source) {
            result.add(0, g2);
        }
        return result;
    }

    private IEntityImage computeImage(IGroup g2) throws IOException, InterruptedException {
        GroupPngMakerState maker = new GroupPngMakerState(this.diagram, g2, this.stringBounder);
        return maker.getImage();
    }
}

