/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.cute.CutePath;
import znaishaded.net.sourceforge.plantuml.cute.MyDouble;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class VarArgs {
    private final Map<String, String> args = new HashMap<String, String>();

    public VarArgs(String data) {
        for (String s2 : data.split("\\s")) {
            if (!s2.contains("=")) continue;
            StringTokenizer st = new StringTokenizer(s2, "=");
            String key = st.nextToken();
            String value = st.nextToken();
            this.args.put(key, value);
        }
    }

    public String toString() {
        return this.args.toString();
    }

    public double getAsDouble(String k, double def) {
        if (this.args.containsKey(k)) {
            return this.getAsDouble(k);
        }
        return def;
    }

    public double getAsDouble(String k) {
        String value = this.args.get(k);
        if (value == null) {
            throw new IllegalArgumentException("no key " + k);
        }
        return Double.parseDouble(value);
    }

    public MyDouble getAsMyDouble(String k) {
        String value = this.args.get(k);
        if (value == null) {
            throw new IllegalArgumentException("no key " + k);
        }
        return new MyDouble(value);
    }

    public HColor getAsColor(String k) {
        String value = this.args.get(k);
        if (value == null) {
            return HColorUtils.BLACK;
        }
        HColor result = HColorSet.instance().getColorIfValid(value);
        if (result == null) {
            return HColorUtils.BLACK;
        }
        return result;
    }

    public Point2D getAsPoint(String k) {
        String value = this.args.get(k);
        if (value == null) {
            throw new IllegalArgumentException("no key " + k);
        }
        StringTokenizer st = new StringTokenizer(value.replaceAll("[()]", ""), ",");
        return new Point2D.Double(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
    }

    public Point2D getAsPoint(String k, Point2D def) {
        if (this.args.containsKey(k)) {
            return this.getAsPoint(k);
        }
        return def;
    }

    public CutePath getPointList(String k) {
        String value = this.args.get(k);
        if (value == null) {
            throw new IllegalArgumentException("no key " + k);
        }
        return new CutePath(value);
    }

    public UTranslate getPosition() {
        return new UTranslate(this.getAsPoint("position", new Point2D.Double()));
    }
}

