/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ditaa;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.command.PSystemBasicFactory;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.ditaa.PSystemDitaa;

public class PSystemDitaaFactory
extends PSystemBasicFactory<PSystemDitaa> {
    public PSystemDitaaFactory(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public PSystemDitaa init(String startLine) {
        boolean performSeparationOfCommonEdges = true;
        if (startLine != null && (startLine.contains("-E") || startLine.contains("--no-separation"))) {
            performSeparationOfCommonEdges = false;
        }
        boolean dropShadows = true;
        if (startLine != null && (startLine.contains("-S") || startLine.contains("--no-shadows"))) {
            dropShadows = false;
        }
        float scale = this.extractScale(startLine);
        if (this.getDiagramType() == DiagramType.UML) {
            return null;
        }
        if (this.getDiagramType() == DiagramType.DITAA) {
            return new PSystemDitaa("", performSeparationOfCommonEdges, dropShadows, scale);
        }
        throw new IllegalStateException(this.getDiagramType().name());
    }

    @Override
    public PSystemDitaa executeLine(PSystemDitaa system, String line) {
        if (system == null && (line.equals("ditaa") || line.startsWith("ditaa("))) {
            boolean performSeparationOfCommonEdges = true;
            if (line.contains("-E") || line.contains("--no-separation")) {
                performSeparationOfCommonEdges = false;
            }
            boolean dropShadows = true;
            if (line.contains("-S") || line.contains("--no-shadows")) {
                dropShadows = false;
            }
            float scale = this.extractScale(line);
            return new PSystemDitaa("", performSeparationOfCommonEdges, dropShadows, scale);
        }
        if (system == null) {
            return null;
        }
        return system.add(line);
    }

    private float extractScale(String line) {
        if (line == null) {
            return 1.0f;
        }
        Pattern p = Pattern.compile("scale=([\\d.]+)");
        Matcher m3 = p.matcher(line);
        if (m3.find()) {
            String number = m3.group(1);
            return Float.parseFloat(number);
        }
        return 1.0f;
    }
}

