/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorBackground;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class SymbolContext {
    private final HColor backColor;
    private final HColor foreColor;
    private final UStroke stroke;
    private final double deltaShadow;
    private final double roundCorner;
    private final double diagonalCorner;

    private SymbolContext(HColor backColor, HColor foreColor, UStroke stroke, double deltaShadow, double roundCorner, double diagonalCorner) {
        this.backColor = backColor;
        this.foreColor = foreColor;
        this.stroke = stroke;
        this.deltaShadow = deltaShadow;
        this.roundCorner = roundCorner;
        this.diagonalCorner = diagonalCorner;
    }

    public String toString() {
        return super.toString() + " backColor=" + this.backColor + " foreColor=" + this.foreColor;
    }

    public final UGraphic apply(UGraphic ug) {
        ug = this.applyColors(ug);
        ug = this.applyStroke(ug);
        return ug;
    }

    public UGraphic applyColors(UGraphic ug) {
        ug = ug.apply(this.foreColor);
        ug = this.backColor == null ? ug.apply(new HColorNone().bg()) : ug.apply(this.backColor.bg());
        return ug;
    }

    public UGraphic applyStroke(UGraphic ug) {
        return ug.apply(this.stroke);
    }

    public SymbolContext transparentBackColorToNull() {
        if (this.backColor instanceof HColorBackground) {
            return new SymbolContext(((HColorBackground)this.backColor).getNull(), this.foreColor, this.stroke, this.deltaShadow, this.roundCorner, this.diagonalCorner);
        }
        return this;
    }

    public SymbolContext(HColor backColor, HColor foreColor) {
        this(backColor, foreColor, new UStroke(), 0.0, 0.0, 0.0);
    }

    public SymbolContext withShadow(double deltaShadow2) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, deltaShadow2, this.roundCorner, this.diagonalCorner);
    }

    public SymbolContext withDeltaShadow(double deltaShadow2) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, deltaShadow2, this.roundCorner, this.diagonalCorner);
    }

    public SymbolContext withStroke(UStroke newStroke) {
        return new SymbolContext(this.backColor, this.foreColor, newStroke, this.deltaShadow, this.roundCorner, this.diagonalCorner);
    }

    public SymbolContext withBackColor(HColor backColor) {
        return new SymbolContext(backColor, this.foreColor, this.stroke, this.deltaShadow, this.roundCorner, this.diagonalCorner);
    }

    public SymbolContext withForeColor(HColor foreColor) {
        return new SymbolContext(this.backColor, foreColor, this.stroke, this.deltaShadow, this.roundCorner, this.diagonalCorner);
    }

    public SymbolContext withCorner(double roundCorner, double diagonalCorner) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, this.deltaShadow, roundCorner, diagonalCorner);
    }

    public HColor getBackColor() {
        return this.backColor;
    }

    public HColor getForeColor() {
        return this.foreColor;
    }

    public UStroke getStroke() {
        return this.stroke;
    }

    public boolean isShadowing() {
        return this.deltaShadow > 0.0;
    }

    public double getDeltaShadow() {
        return this.deltaShadow;
    }

    public double getRoundCorner() {
        return this.roundCorner;
    }

    public double getDiagonalCorner() {
        return this.diagonalCorner;
    }
}

