/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.timescale;

import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.GCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScale;
import znaishaded.net.sourceforge.plantuml.project.timescale.TimeScaleDaily;

public class TimeScaleCompressed
implements TimeScale {
    private final int compress;
    private final TimeScale daily;
    private final GCalendar calendar;

    public TimeScaleCompressed(GCalendar calendar, int compress) {
        this.daily = new TimeScaleDaily(calendar, null);
        this.compress = compress;
        this.calendar = calendar;
    }

    @Override
    public double getStartingPosition(Wink instant) {
        return this.daily.getStartingPosition(instant) / (double)this.compress;
    }

    @Override
    public double getEndingPosition(Wink instant) {
        return this.daily.getEndingPosition(instant) / (double)this.compress;
    }

    @Override
    public double getWidth(Wink instant) {
        return this.daily.getWidth(instant) / (double)this.compress;
    }

    @Override
    public boolean isBreaking(Wink instant) {
        Day day = this.calendar.toDayAsDate(instant);
        return day.getDayOfWeek() == DayOfWeek.SUNDAY;
    }
}

