/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandReferenceOverSeveral
extends SingleLineCommand2<SequenceDiagram> {
    public CommandReferenceOverSeveral() {
        super(CommandReferenceOverSeveral.getConcat());
    }

    private static RegexConcat getConcat() {
        return RegexConcat.build(CommandReferenceOverSeveral.class.getName(), RegexLeaf.start(), new RegexLeaf("ref"), new RegexLeaf("REF", "(#\\w+)?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("over"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTS", "(([\\p{L}0-9_.@]+|[%g][^%g]+[%g])([%s]*,[%s]*([\\p{L}0-9_.@]+|[%g][^%g]+[%g]))*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("URL", "\\[\\[([^|]*)(?:\\|([^|]*))?\\]\\]")), new RegexLeaf("TEXT", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        HColor backColorElement = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("REF", 0));
        List<String> participants = StringUtils.splitComma(arg.get("PARTS", 0));
        String url = arg.get("URL", 0);
        String title = arg.get("URL", 1);
        String text = StringUtils.trin(arg.get("TEXT", 0));
        ArrayList<Participant> p = new ArrayList<Participant>();
        for (String s2 : participants) {
            p.add(diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2)));
        }
        Display strings = Display.getWithNewlines(text);
        Url u = null;
        if (url != null) {
            u = new Url(url, title);
        }
        HColor backColorGeneral = null;
        Reference ref = new Reference(p, u, strings, backColorGeneral, backColorElement, diagram.getSkinParam().getCurrentStyleBuilder());
        diagram.addReference(ref);
        return CommandExecutionResult.ok();
    }
}

