/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcolored;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcoloredReference;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Bordered;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class TileArguments
implements Bordered {
    private final StringBounder stringBounder;
    private final Real origin;
    private final LivingSpaces livingSpaces;
    private final Rose skin;
    private final ISkinParam skinParam;
    private Bordered bordered;

    public TileArguments(StringBounder stringBounder, LivingSpaces livingSpaces, Rose skin, ISkinParam skinParam, Real origin) {
        this.stringBounder = stringBounder;
        this.origin = origin;
        this.livingSpaces = livingSpaces;
        this.skin = skin;
        this.skinParam = skinParam;
    }

    public TileArguments withBackColorGeneral(HColor backColorElement, HColor backColorGeneral) {
        return new TileArguments(this.stringBounder, this.livingSpaces, this.skin, new SkinParamBackcolored(this.skinParam, backColorElement, backColorGeneral), this.origin);
    }

    public TileArguments withBackColor(Reference reference) {
        SkinParamBackcoloredReference newSkinParam = new SkinParamBackcoloredReference(this.skinParam, reference.getBackColorElement(), reference.getBackColorGeneral());
        return new TileArguments(this.stringBounder, this.livingSpaces, this.skin, newSkinParam, this.origin);
    }

    public final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public final Real getOrigin() {
        return this.origin;
    }

    public final LivingSpaces getLivingSpaces() {
        return this.livingSpaces;
    }

    public final Rose getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public LivingSpace getLivingSpace(Participant p) {
        return this.livingSpaces.get(p);
    }

    public LivingSpace getFirstLivingSpace() {
        return this.livingSpaces.values().iterator().next();
    }

    public LivingSpace getLastLivingSpace() {
        LivingSpace result = null;
        Iterator<LivingSpace> iterator = this.livingSpaces.values().iterator();
        while (iterator.hasNext()) {
            LivingSpace v;
            result = v = iterator.next();
        }
        return result;
    }

    public void setBordered(Bordered bordered) {
        this.bordered = bordered;
    }

    @Override
    public double getBorder1() {
        return this.bordered.getBorder1();
    }

    @Override
    public double getBorder2() {
        return this.bordered.getBorder2();
    }
}

