/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Line2D;
import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;

public class DriverLineSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverLineSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        HColor color;
        ULine shape = (ULine)ushape;
        double x2 = x + shape.getDX();
        double y2 = y + shape.getDY();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Line2D.Double line = clip.getClippedLine(new Line2D.Double(x, y, x2, y2));
            if (line == null) {
                return;
            }
            x = line.x1;
            y = line.y1;
            x2 = line.x2;
            y2 = line.y2;
        }
        if ((color = param.getColor()) instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)color;
            svg.setStrokeColor(mapper.toSvg(gr.getColor1()));
        } else {
            svg.setStrokeColor(mapper.toSvg(color));
        }
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        svg.svgLine(x, y, x2, y2, shape.getDeltaShadow());
    }
}

