/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.plugin;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.Doxygen;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;
import org.testingisdocumenting.znai.doxygen.plugin.DoxygenDocIncludePlugin;
import org.testingisdocumenting.znai.doxygen.plugin.DoxygenMemberIncludePlugin;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.CollectionUtils;

public class DoxygenCompoundIncludePlugin
implements IncludePlugin {
    private static final HeadingProps headingProps = new HeadingProps(Collections.singletonMap("style", "api"));
    private DoxygenCompound compound;
    private ComponentsRegistry componentsRegistry;
    private ParserHandler parserHandler;
    private Path markupPath;

    @Override
    public String id() {
        return "doxygen-compound";
    }

    @Override
    public IncludePlugin create() {
        return new DoxygenCompoundIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.componentsRegistry = componentsRegistry;
        this.parserHandler = parserHandler;
        this.markupPath = markupPath;
        Doxygen doxygen = Doxygen.INSTANCE;
        String fullName = pluginParams.getFreeParam();
        this.compound = doxygen.getCachedOrFindAndParseCompound(componentsRegistry, fullName);
        if (this.compound == null) {
            throw new RuntimeException("can't find compound: " + fullName + ", available names:\n" + doxygen.buildIndexOrGetCached(componentsRegistry).renderAvailableCompoundNames());
        }
        parserHandler.onGlobalAnchor(this.compound.getId());
        parserHandler.onSectionStart(this.compound.getName(), new HeadingProps(CollectionUtils.createMap("badge", this.compound.getKind(), "style", "api")));
        this.insertDocs(fullName);
        this.declBlock("Public Functions", this.compound.publicNonStaticFunctionsStream());
        this.declBlock("Static Public Functions", this.compound.publicStaticFunctionsStream());
        this.declBlock("Public Attributes", this.compound.publicNonStaticAttributesStream());
        this.declBlock("Static Public Attributes", this.compound.publicStaticAttributesStream());
        this.declBlock("Protected Functions", this.compound.protectedFunctionsStream());
        parserHandler.onSubHeading(3, "Definitions", headingProps);
        this.compound.publicNonStaticFunctionsStream().forEach(this::createMemberDef);
        this.compound.publicStaticFunctionsStream().forEach(this::createMemberDef);
        this.compound.publicNonStaticAttributesStream().forEach(this::createMemberDef);
        this.compound.publicStaticAttributesStream().forEach(this::createMemberDef);
        this.compound.protectedFunctionsStream().forEach(this::createMemberDef);
        return PluginResult.docElements(Stream.empty());
    }

    private void declBlock(String name, Stream<DoxygenMember> memberStream) {
        List<DoxygenMember> members = memberStream.collect(Collectors.toList());
        if (members.isEmpty()) {
            return;
        }
        this.parserHandler.onSubHeading(3, name, headingProps);
        members.forEach(this::createMemberDecl);
    }

    private void insertDocs(String fullName) {
        IncludePlugin includePlugin = DoxygenDocIncludePlugin.createDocPlugin();
        PluginResult pluginResult = includePlugin.process(this.componentsRegistry, this.parserHandler, this.markupPath, new PluginParams(includePlugin.id(), fullName));
        this.parserHandler.onIncludePlugin(includePlugin, pluginResult);
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.HIGH.text(this.compound.getName());
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(Doxygen.INSTANCE.getIndexPath()));
    }

    public void createMemberDecl(DoxygenMember member) {
        Map<String, Object> memberProps = member.toMap();
        memberProps.put("compoundName", "");
        memberProps.put("refId", member.getId());
        this.parserHandler.onCustomNode("DoxygenMember", memberProps);
    }

    public void createMemberDef(DoxygenMember member) {
        this.parserHandler.onSubHeading(4, member.getName(), headingProps);
        IncludePlugin includePlugin = DoxygenMemberIncludePlugin.createMemberPlugin();
        PluginResult pluginResult = includePlugin.process(this.componentsRegistry, this.parserHandler, this.markupPath, new PluginParams(includePlugin.id(), member.getFullName()));
        this.parserHandler.onIncludePlugin(includePlugin, pluginResult);
    }
}

