/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParametersAnchors;

public class ApiParameter {
    private final String anchorId;
    private final String name;
    private final ApiLinkedText type;
    private final List<Map<String, Object>> description;
    private final String textForSearch;
    private final List<ApiParameter> children;

    public ApiParameter(String anchorId, String name, ApiLinkedText type, List<Map<String, Object>> description, String textForSearch) {
        this.anchorId = anchorId;
        this.name = name;
        this.type = type;
        this.description = description;
        this.textForSearch = textForSearch;
        this.children = new ArrayList<ApiParameter>();
    }

    public String getName() {
        return this.name;
    }

    public ApiLinkedText getType() {
        return this.type;
    }

    public List<Map<String, Object>> getDescription() {
        return this.description;
    }

    public String getTextForSearch() {
        return this.textForSearch;
    }

    public String combinedTextForSearch() {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.name);
        parts.add(this.type.buildCombinedText());
        parts.add(this.textForSearch);
        this.children.forEach(c -> parts.add(c.combinedTextForSearch()));
        return String.join((CharSequence)" ", parts);
    }

    public List<String> collectAllAnchors() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.anchorId);
        this.children.forEach(child -> result.addAll(child.collectAllAnchors()));
        return result;
    }

    public List<ApiParameter> getChildren() {
        return this.children;
    }

    public ApiParameter addInFront(String name, ApiLinkedText type, List<Map<String, Object>> description, String textForSearch) {
        ApiParameter apiParameter = new ApiParameter(ApiParametersAnchors.anchorIdFromNameAndPrefix(this.anchorId, name), name, type, description, textForSearch);
        this.children.add(0, apiParameter);
        return apiParameter;
    }

    public ApiParameter add(String name, ApiLinkedText type, List<Map<String, Object>> description, String textForSearch) {
        ApiParameter apiParameter = new ApiParameter(ApiParametersAnchors.anchorIdFromNameAndPrefix(this.anchorId, name), name, type, description, textForSearch);
        this.children.add(apiParameter);
        return apiParameter;
    }

    ApiParameter find(String name) {
        return this.children.stream().filter(p -> p.name.equals(name)).findFirst().orElseThrow(() -> new RuntimeException("no children found with name: '" + name + "' in '" + this.name + "'"));
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.name);
        result.put("type", this.type.toListOfMaps());
        result.put("anchorId", this.anchorId);
        result.put("description", this.description);
        if (!this.children.isEmpty()) {
            result.put("children", this.children.stream().map(ApiParameter::toMap).collect(Collectors.toList()));
        }
        return result;
    }
}

