/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.commonmark;

import java.nio.file.Path;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.Plugins;
import org.testingisdocumenting.znai.extensions.PluginsRegexp;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.commonmark.ValidateNoExtraSyntaxExceptInlineCodeInHeadingVisitor;
import org.testingisdocumenting.znai.parser.commonmark.include.IncludeBlock;
import org.testingisdocumenting.znai.parser.table.GfmTableToTableConverter;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.utils.JsonParseException;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.org.commonmark.ext.front.matter.YamlFrontMatterBlock;
import znaishaded.org.commonmark.ext.gfm.strikethrough.Strikethrough;
import znaishaded.org.commonmark.ext.gfm.tables.TableBlock;
import znaishaded.org.commonmark.node.AbstractVisitor;
import znaishaded.org.commonmark.node.BlockQuote;
import znaishaded.org.commonmark.node.BulletList;
import znaishaded.org.commonmark.node.Code;
import znaishaded.org.commonmark.node.CustomBlock;
import znaishaded.org.commonmark.node.CustomNode;
import znaishaded.org.commonmark.node.Emphasis;
import znaishaded.org.commonmark.node.FencedCodeBlock;
import znaishaded.org.commonmark.node.HardLineBreak;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.commonmark.node.Image;
import znaishaded.org.commonmark.node.IndentedCodeBlock;
import znaishaded.org.commonmark.node.Link;
import znaishaded.org.commonmark.node.ListItem;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.node.OrderedList;
import znaishaded.org.commonmark.node.Paragraph;
import znaishaded.org.commonmark.node.SoftLineBreak;
import znaishaded.org.commonmark.node.StrongEmphasis;
import znaishaded.org.commonmark.node.Text;
import znaishaded.org.commonmark.node.ThematicBreak;

public class MarkdownVisitor
extends AbstractVisitor {
    private final ComponentsRegistry componentsRegistry;
    private final Path path;
    private final ParserHandler parserHandler;
    private boolean sectionStarted;

    public MarkdownVisitor(ComponentsRegistry componentsRegistry, Path path, ParserHandler parserHandler) {
        this.componentsRegistry = componentsRegistry;
        this.path = path;
        this.parserHandler = parserHandler;
    }

    public boolean isSectionStarted() {
        return this.sectionStarted;
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.parserHandler.onParagraphStart();
        this.visitChildren(paragraph);
        this.parserHandler.onParagraphEnd();
    }

    @Override
    public void visit(Emphasis emphasis) {
        this.parserHandler.onEmphasisStart();
        this.visitChildren(emphasis);
        this.parserHandler.onEmphasisEnd();
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.parserHandler.onStrongEmphasisStart();
        this.visitChildren(strongEmphasis);
        this.parserHandler.onStrongEmphasisEnd();
    }

    @Override
    public void visit(Text text) {
        this.parserHandler.onSimpleText(text.getLiteral());
    }

    @Override
    public void visit(BulletList bulletList) {
        this.parserHandler.onBulletListStart(bulletList.getBulletMarker(), bulletList.isTight());
        this.visitChildren(bulletList);
        this.parserHandler.onBulletListEnd();
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.parserHandler.onOrderedListStart(orderedList.getDelimiter(), orderedList.getStartNumber());
        this.visitChildren(orderedList);
        this.parserHandler.onOrderedListEnd();
    }

    @Override
    public void visit(ListItem listItem) {
        this.parserHandler.onListItemStart();
        this.visitChildren(listItem);
        this.parserHandler.onListItemEnd();
    }

    @Override
    public void visit(Code code) {
        String literal = code.getLiteral();
        PluginsRegexp.IdAndParams idAndParams = PluginsRegexp.parseInlinedCodePlugin(literal);
        if (idAndParams != null && Plugins.hasInlinedCodePlugin(idAndParams.getId())) {
            this.handleInlineCodePlugin(new PluginParams(idAndParams.getId(), idAndParams.getParams()));
        } else {
            this.parserHandler.onInlinedCode(literal, DocReferences.EMPTY);
        }
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        this.parserHandler.onThematicBreak();
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.parserHandler.onHardLineBreak();
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.parserHandler.onSoftLineBreak();
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.parserHandler.onBlockQuoteStart();
        this.visitChildren(blockQuote);
        this.parserHandler.onBlockQuoteEnd();
    }

    @Override
    public void visit(CustomBlock customBlock) {
        if (customBlock instanceof YamlFrontMatterBlock) {
            return;
        }
        if (customBlock instanceof IncludeBlock) {
            IncludeBlock includeBlock = (IncludeBlock)customBlock;
            this.handleIncludePlugin(includeBlock.getParams());
        } else if (customBlock instanceof TableBlock) {
            GfmTableToTableConverter gfmTableToTableConverter = new GfmTableToTableConverter(this.componentsRegistry, this.path, (TableBlock)customBlock);
            this.parserHandler.onTable(gfmTableToTableConverter.convert());
        } else {
            throw new UnsupportedOperationException("unsupported custom block: " + customBlock);
        }
    }

    @Override
    public void visit(CustomNode customNode) {
        if (customNode instanceof Strikethrough) {
            this.parserHandler.onStrikeThroughStart();
            this.visitChildren(customNode);
            this.parserHandler.onStrikeThroughEnd();
        } else {
            super.visit(customNode);
        }
    }

    @Override
    public void visit(Image image) {
        Node firstChild = image.getFirstChild();
        String alt = this.extractText(firstChild);
        this.parserHandler.onImage(image.getTitle(), image.getDestination(), alt.isEmpty() ? "image" : alt);
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.parserHandler.onSnippet(PluginParams.EMPTY, "", "", indentedCodeBlock.getLiteral());
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        PluginParams pluginParams = MarkdownVisitor.extractFencePluginParams(fencedCodeBlock.getInfo().trim());
        if (Plugins.hasFencePlugin(pluginParams.getPluginId())) {
            this.handleFencePlugin(pluginParams, fencedCodeBlock.getLiteral());
        } else {
            this.parserHandler.onSnippet(pluginParams, pluginParams.getPluginId(), "", fencedCodeBlock.getLiteral());
        }
    }

    @Override
    public void visit(Link link) {
        this.parserHandler.onLinkStart(link.getDestination());
        this.visitChildren(link);
        this.parserHandler.onLinkEnd();
    }

    @Override
    public void visit(Heading heading) {
        HeadingTextAndProps headingTextAndProps = this.extractHeadingTextAndProps(heading);
        if (heading.getLevel() == 1) {
            if (this.sectionStarted) {
                this.parserHandler.onSectionEnd();
            }
            this.parserHandler.onSectionStart(headingTextAndProps.text, headingTextAndProps.props);
            this.sectionStarted = true;
        } else {
            this.parserHandler.onSubHeading(heading.getLevel(), headingTextAndProps.text, headingTextAndProps.props);
        }
    }

    private void handleIncludePlugin(PluginParams params) {
        try {
            IncludePlugin includePlugin = Plugins.includePluginById(params.getPluginId());
            PluginResult pluginResult = includePlugin.process(this.componentsRegistry, this.parserHandler, this.path, params);
            this.parserHandler.onIncludePlugin(includePlugin, pluginResult);
        }
        catch (Exception e) {
            throw new RuntimeException(MarkdownVisitor.createPluginErrorMessage("include", params, e), e);
        }
    }

    private void handleFencePlugin(PluginParams params, String fenceContent) {
        try {
            FencePlugin fencePlugin = Plugins.fencePluginById(params.getPluginId());
            PluginResult pluginResult = fencePlugin.process(this.componentsRegistry, this.path, params, fenceContent);
            this.parserHandler.onFencePlugin(fencePlugin, pluginResult);
        }
        catch (Exception e) {
            throw new RuntimeException(MarkdownVisitor.createPluginErrorMessage("fence", params, e) + "\n  fence content:\n" + fenceContent);
        }
    }

    private void handleInlineCodePlugin(PluginParams params) {
        try {
            InlinedCodePlugin inlinedCodePlugin = Plugins.inlinedCodePluginById(params.getPluginId());
            PluginResult pluginResult = inlinedCodePlugin.process(this.componentsRegistry, this.path, params);
            this.parserHandler.onInlinedCodePlugin(inlinedCodePlugin, pluginResult);
        }
        catch (Exception e) {
            throw new RuntimeException(MarkdownVisitor.createPluginErrorMessage("inline code", params, e));
        }
    }

    private static String createPluginErrorMessage(String pluginType, PluginParams params, Exception e) {
        return "error handling " + pluginType + " plugin <" + params.getPluginId() + ">: " + e.getMessage() + "\n  free param: " + params.getFreeParam() + "\n  opts: " + JsonUtils.serialize(params.getOpts().toMap());
    }

    private static PluginParams extractFencePluginParams(String nameAndParams) {
        int firstSpaceIdx = nameAndParams.indexOf(32);
        return firstSpaceIdx == -1 ? new PluginParams(nameAndParams, "") : new PluginParams(nameAndParams.substring(0, firstSpaceIdx), nameAndParams.substring(firstSpaceIdx + 1));
    }

    private HeadingTextAndProps extractHeadingTextAndProps(Heading heading) {
        heading.accept(ValidateNoExtraSyntaxExceptInlineCodeInHeadingVisitor.INSTANCE);
        Node firstChild = heading.getFirstChild();
        if (firstChild == null) {
            return new HeadingTextAndProps("", HeadingProps.EMPTY);
        }
        String extractedText = this.extractText(firstChild);
        int startOfCurlyIdx = extractedText.indexOf(123);
        if (startOfCurlyIdx == -1) {
            return new HeadingTextAndProps(extractedText, HeadingProps.EMPTY);
        }
        try {
            String jsonStart = extractedText.substring(startOfCurlyIdx);
            Map<String, ?> props = JsonUtils.deserializeAsMap(jsonStart);
            String headingTextOnly = extractedText.substring(0, startOfCurlyIdx).trim();
            return new HeadingTextAndProps(headingTextOnly, new HeadingProps(props));
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Can't parse props of heading: " + extractedText, e);
        }
    }

    private String extractText(Node node) {
        if (node == null) {
            return "";
        }
        return ((Text)node).getLiteral().trim();
    }

    private static class HeadingTextAndProps {
        private final String text;
        private final HeadingProps props;

        public HeadingTextAndProps(String text, HeadingProps props) {
            this.text = text;
            this.props = props;
        }
    }
}

