/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.reference;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.reference.DocReferencesParser;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.utils.FileUtils;

public class GlobalDocReferences {
    private final ComponentsRegistry componentsRegistry;
    private final Path globalReferencesPath;
    private DocReferences docReferences;

    public GlobalDocReferences(ComponentsRegistry componentsRegistry, Path globalReferencesPath) {
        this.componentsRegistry = componentsRegistry;
        this.globalReferencesPath = globalReferencesPath;
    }

    public boolean isPresent() {
        return Files.exists(this.globalReferencesPath, new LinkOption[0]);
    }

    public void load() {
        this.docReferences = this.isPresent() ? DocReferencesParser.parse(FileUtils.fileTextContent(this.globalReferencesPath)) : new DocReferences();
        this.validateLinks();
    }

    private void validateLinks() {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        this.docReferences.pageUrlsStream().forEach(pageUrl -> docStructure.validateUrl(this.globalReferencesPath, "", new DocUrl((String)pageUrl)));
    }

    public Path getGlobalReferencesPath() {
        return this.globalReferencesPath;
    }

    public DocReferences getDocReferences() {
        return this.docReferences;
    }
}

