/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http;

import java.util.Objects;
import znaishaded.io.vertx.codegen.annotations.DataObject;
import znaishaded.io.vertx.codegen.annotations.GenIgnore;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.http.RequestOptionsConverter;
import znaishaded.io.vertx.core.json.JsonObject;

@DataObject(generateConverter=true)
public class RequestOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 80;
    public static final Boolean DEFAULT_SSL = null;
    public static final String DEFAULT_URI = "";
    private String host;
    private int port;
    private Boolean ssl;
    private String uri;
    private MultiMap headers;

    public RequestOptions() {
        this.host = DEFAULT_HOST;
        this.port = 80;
        this.ssl = DEFAULT_SSL;
        this.uri = DEFAULT_URI;
    }

    public RequestOptions(RequestOptions other) {
        this.setHost(other.host);
        this.setPort(other.port);
        this.setSsl(other.ssl);
        this.setURI(other.uri);
    }

    public RequestOptions(JsonObject json) {
        RequestOptionsConverter.fromJson(json, this);
    }

    public String getHost() {
        return this.host;
    }

    public RequestOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RequestOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public Boolean isSsl() {
        return this.ssl;
    }

    public RequestOptions setSsl(Boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public RequestOptions setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public RequestOptions addHeader(String key, String value) {
        this.checkHeaders();
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @GenIgnore
    public RequestOptions setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    private void checkHeaders() {
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RequestOptionsConverter.toJson(this, json);
        return json;
    }
}

