/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.nio.charset.Charset;
import znaishaded.io.vertx.core.Context;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.file.AsyncFile;
import znaishaded.io.vertx.core.file.OpenOptions;
import znaishaded.io.vertx.core.http.HttpServerFileUpload;
import znaishaded.io.vertx.core.streams.Pipe;
import znaishaded.io.vertx.core.streams.ReadStream;

class HttpServerFileUploadImpl
implements HttpServerFileUpload {
    private final ReadStream<Buffer> stream;
    private final Context context;
    private final String name;
    private final String filename;
    private final String contentType;
    private final String contentTransferEncoding;
    private final Charset charset;
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private AsyncFile file;
    private Handler<Throwable> exceptionHandler;
    private long size;
    private boolean lazyCalculateSize;

    HttpServerFileUploadImpl(Context context, ReadStream<Buffer> stream, String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size) {
        this.context = context;
        this.stream = stream;
        this.name = name;
        this.filename = filename;
        this.contentType = contentType;
        this.contentTransferEncoding = contentTransferEncoding;
        this.charset = charset;
        this.size = size;
        this.lazyCalculateSize = size == 0L;
        stream.handler(this::handleData);
        stream.endHandler((Void v) -> this.handleEnd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(Buffer data) {
        Handler<Buffer> h2;
        HttpServerFileUploadImpl httpServerFileUploadImpl = this;
        synchronized (httpServerFileUploadImpl) {
            h2 = this.dataHandler;
            this.size += (long)data.length();
        }
        if (h2 != null) {
            h2.handle(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEnd() {
        Handler<Void> handler;
        HttpServerFileUploadImpl httpServerFileUploadImpl = this;
        synchronized (httpServerFileUploadImpl) {
            this.lazyCalculateSize = false;
            handler = this.endHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    private void notifyExceptionHandler(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(cause);
        }
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public String contentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public String charset() {
        return this.charset.toString();
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    @Override
    public synchronized HttpServerFileUpload handler(Handler<Buffer> handler) {
        this.dataHandler = handler;
        return this;
    }

    @Override
    public HttpServerFileUpload pause() {
        this.stream.pause();
        return this;
    }

    @Override
    public HttpServerFileUpload fetch(long amount) {
        this.stream.fetch(amount);
        return this;
    }

    @Override
    public HttpServerFileUpload resume() {
        this.stream.resume();
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public synchronized HttpServerFileUpload endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public HttpServerFileUpload streamToFileSystem(String filename) {
        Pipe<Buffer> pipe = this.stream.pipe().endOnComplete(false);
        this.context.owner().fileSystem().open(filename, new OpenOptions(), ar -> {
            if (ar.succeeded()) {
                this.file = (AsyncFile)ar.result();
                pipe.to(this.file, ar2 -> this.file.close(ar3 -> {
                    Throwable failure;
                    Throwable throwable = ar2.failed() ? ar2.cause() : (failure = ar3.failed() ? ar3.cause() : null);
                    if (failure != null) {
                        this.notifyExceptionHandler(failure);
                    }
                    HttpServerFileUploadImpl httpServerFileUploadImpl = this;
                    synchronized (httpServerFileUploadImpl) {
                        this.size = this.file.getWritePos();
                    }
                    this.handleEnd();
                }));
            } else {
                pipe.close();
                this.notifyExceptionHandler(ar.cause());
            }
        });
        return this;
    }

    @Override
    public synchronized boolean isSizeAvailable() {
        return !this.lazyCalculateSize;
    }

    @Override
    public synchronized AsyncFile file() {
        return this.file;
    }
}

