/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import java.util.List;
import znaishaded.io.vertx.codegen.annotations.Nullable;
import znaishaded.io.vertx.ext.web.LanguageHeader;
import znaishaded.io.vertx.ext.web.impl.HeaderParser;
import znaishaded.io.vertx.ext.web.impl.ParsableHeaderValue;

public class ParsableLanguageValue
extends ParsableHeaderValue
implements LanguageHeader {
    private List<String> parsedValues = null;
    private boolean processed = false;

    public ParsableLanguageValue(String headerContent) {
        super(headerContent);
    }

    @Override
    public String tag() {
        return this.subtag(0);
    }

    @Override
    public String language() {
        String value = this.tag();
        return value == null ? null : value.toLowerCase();
    }

    @Override
    public @Nullable String subtag() {
        return this.subtag(1);
    }

    @Override
    public @Nullable String country() {
        String value = this.subtag(1);
        return value == null ? null : value.toUpperCase();
    }

    @Override
    public @Nullable String variant() {
        String value = this.subtag(2);
        return value == null ? null : value.toUpperCase();
    }

    @Override
    public @Nullable String subtag(int level) {
        this.ensureHeaderProcessed();
        if (level < this.parsedValues.size()) {
            return this.parsedValues.get(level);
        }
        return null;
    }

    @Override
    public int subtagCount() {
        this.ensureHeaderProcessed();
        return this.parsedValues != null ? this.parsedValues.size() : 0;
    }

    @Override
    protected boolean isMatchedBy2(ParsableHeaderValue matchTry) {
        ParsableLanguageValue myMatchTry = (ParsableLanguageValue)matchTry;
        this.ensureHeaderProcessed();
        for (int i = 0; i < myMatchTry.parsedValues.size(); ++i) {
            String match = myMatchTry.parsedValues.get(i);
            String against = this.parsedValues.get(i);
            if ("*".equals(match) || match.equalsIgnoreCase(against)) continue;
            return false;
        }
        return super.isMatchedBy2(myMatchTry);
    }

    @Override
    protected void ensureHeaderProcessed() {
        if (!this.processed) {
            this.processed = true;
            super.ensureHeaderProcessed();
            this.parsedValues = HeaderParser.parseLanguageValue(this.value);
        }
    }
}

