/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.Annotated;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplaySection;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;

public abstract class TitledDiagram
extends AbstractPSystem
implements Diagram,
Annotated {
    private DisplayPositionned title = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    private DisplayPositionned caption = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositionned legend = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private final DisplaySection header = DisplaySection.none();
    private final DisplaySection footer = DisplaySection.none();
    private Display mainFrame;
    private final SkinParam skinParam = SkinParam.create(this.getUmlDiagramType());

    public TitledDiagram() {
    }

    public TitledDiagram(ISkinSimple orig) {
        this();
        if (orig != null) {
            this.skinParam.copyAllFrom(orig);
        }
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String key, String value) {
        this.skinParam.setParam(StringUtils.goLowerCase(key), value);
    }

    public void addSprite(String name, Sprite sprite) {
        this.skinParam.addSprite(name, sprite);
    }

    public CommandExecutionResult loadSkin(String newSkin) throws IOException {
        this.getSkinParam().setDefaultSkin(newSkin + ".skin");
        return CommandExecutionResult.ok();
    }

    public final void setTitle(DisplayPositionned title) {
        if (title.isNull() || title.getDisplay().isWhite()) {
            return;
        }
        this.title = title;
    }

    @Override
    public final DisplayPositionned getTitle() {
        return this.title;
    }

    public final void setMainFrame(Display mainFrame) {
        this.mainFrame = mainFrame;
    }

    public final void setCaption(DisplayPositionned caption) {
        this.caption = caption;
    }

    @Override
    public final DisplayPositionned getCaption() {
        return this.caption;
    }

    @Override
    public final DisplaySection getHeader() {
        return this.header;
    }

    @Override
    public final DisplaySection getFooter() {
        return this.footer;
    }

    @Override
    public final DisplayPositionned getLegend() {
        return this.legend;
    }

    public void setLegend(DisplayPositionned legend) {
        this.legend = legend;
    }

    @Override
    public final Display getMainFrame() {
        return this.mainFrame;
    }
}

