/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class Branch {
    private final InstructionList list;
    private final Display labelTest;
    private final Display labelPositive;
    private final Display inlabel;
    private final HColor color;
    private LinkRendering inlinkRendering = LinkRendering.none();
    private Ftile ftile;
    private LinkRendering special;

    public StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public boolean containsBreak() {
        return this.list.containsBreak();
    }

    public Branch(StyleBuilder styleBuilder, Swimlane swimlane, Display labelPositive, Display labelTest, HColor color, Display inlabel) {
        if (labelPositive == null) {
            throw new IllegalArgumentException();
        }
        if (labelTest == null) {
            throw new IllegalArgumentException();
        }
        if (inlabel == null) {
            throw new IllegalArgumentException();
        }
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinitionDiamond().getMergedStyle(styleBuilder);
            this.color = color == null ? style.value(PName.BackGroundColor).asColor(styleBuilder.getSkinParam().getIHtmlColorSet()) : color;
        } else {
            this.color = color;
        }
        this.inlabel = inlabel;
        this.list = new InstructionList(swimlane);
        this.labelTest = labelTest;
        this.labelPositive = labelPositive;
    }

    public Collection<WeldingPoint> getWeldingPoints() {
        return this.ftile.getWeldingPoints();
    }

    public void add(Instruction ins) {
        this.list.add(ins);
    }

    public boolean kill() {
        return this.list.kill();
    }

    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        return this.list.addNote(note, position, type, colors, swimlaneNote);
    }

    public final void setInlinkRendering(LinkRendering inlinkRendering) {
        if (inlinkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.inlinkRendering = inlinkRendering;
    }

    public void updateFtile(FtileFactory factory) {
        this.ftile = factory.decorateOut(this.list.createFtile(factory), this.inlinkRendering);
    }

    public Collection<? extends Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    public final Display getLabelPositive() {
        LinkRendering in = this.ftile.getInLinkRendering();
        if (in != null && !Display.isNull(in.getDisplay())) {
            return in.getDisplay();
        }
        return this.labelPositive;
    }

    public final Display getLabelTest() {
        return this.labelTest;
    }

    public final Rainbow getInlinkRenderingColorAndStyle() {
        return this.inlinkRendering == null ? null : this.inlinkRendering.getRainbow();
    }

    public Display getInlabel() {
        return this.inlabel;
    }

    public final Ftile getFtile() {
        return this.ftile;
    }

    public ISkinParam skinParam() {
        return this.ftile.skinParam();
    }

    public final HColor getColor() {
        return this.color;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Instruction getLast() {
        return this.list.getLast();
    }

    public boolean isOnlySingleStopOrSpot() {
        return this.list.isOnlySingleStopOrSpot();
    }

    public void setSpecial(LinkRendering link) {
        this.special = link;
    }

    public final LinkRendering getSpecial() {
        return this.special;
    }
}

