/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextSelfArrow
extends AbstractComponentText
implements ArrowComponent {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final ArrowConfiguration config;

    public ComponentTextSelfArrow(ComponentType type, ArrowConfiguration config, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
        this.config = config;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        if (this.config.isHidden()) {
            return;
        }
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight() - 1;
        charArea.fillRect(' ', 0, 0, width, height);
        if (this.fileFormat == FileFormat.UTXT) {
            if (this.config.isDotted()) {
                charArea.drawStringLR("\u2500 \u2500 \u2510", 0, 0);
                charArea.drawStringLR("|", 4, 1);
                charArea.drawStringLR("< \u2500 \u2518", 0, 2);
            } else {
                charArea.drawStringLR("\u2500\u2500\u2500\u2500\u2510", 0, 0);
                charArea.drawStringLR("\u2502", 4, 1);
                charArea.drawStringLR("<\u2500\u2500\u2500\u2518", 0, 2);
            }
        } else if (this.config.isDotted()) {
            charArea.drawStringLR("- - .", 0, 0);
            charArea.drawStringLR("|", 4, 1);
            charArea.drawStringLR("< - '", 0, 2);
        } else {
            charArea.drawStringLR("----.", 0, 0);
            charArea.drawStringLR("|", 4, 1);
            charArea.drawStringLR("<---'", 0, 2);
        }
        charArea.drawStringsLR(this.stringsToDisplay.as(), 6, 1);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 3;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 6;
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        return new Point2D.Double(0.0, 0.0);
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimensionToUse) {
        return new Point2D.Double(0.0, 0.0);
    }

    @Override
    public double getPaddingY() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }
}

