/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.code.deflate;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.code.deflate.BitInputStream;

final class CanonicalCode {
    private int[] symbolCodeBits;
    private int[] symbolValues;
    private static final int MAX_CODE_LENGTH = 15;

    public CanonicalCode(int[] codeLengths) {
        Objects.requireNonNull(codeLengths);
        for (int x : codeLengths) {
            if (x < 0) {
                throw new IllegalArgumentException("Negative code length");
            }
            if (x <= 15) continue;
            throw new IllegalArgumentException("Maximum code length exceeded");
        }
        this.symbolCodeBits = new int[codeLengths.length];
        this.symbolValues = new int[codeLengths.length];
        int numSymbolsAllocated = 0;
        int nextCode = 0;
        for (int codeLength = 1; codeLength <= 15; ++codeLength) {
            nextCode <<= 1;
            int startBit = 1 << codeLength;
            for (int symbol = 0; symbol < codeLengths.length; ++symbol) {
                if (codeLengths[symbol] != codeLength) continue;
                if (nextCode >= startBit) {
                    throw new IllegalArgumentException("This canonical code produces an over-full Huffman code tree");
                }
                this.symbolCodeBits[numSymbolsAllocated] = startBit | nextCode;
                this.symbolValues[numSymbolsAllocated] = symbol;
                ++numSymbolsAllocated;
                ++nextCode;
            }
        }
        if (nextCode != 32768) {
            throw new IllegalArgumentException("This canonical code produces an under-full Huffman code tree");
        }
        this.symbolCodeBits = Arrays.copyOf(this.symbolCodeBits, numSymbolsAllocated);
        this.symbolValues = Arrays.copyOf(this.symbolValues, numSymbolsAllocated);
    }

    public int decodeNextSymbol(BitInputStream in) throws IOException {
        int index;
        Objects.requireNonNull(in);
        int codeBits = 1;
        while ((index = Arrays.binarySearch(this.symbolCodeBits, codeBits = codeBits << 1 | in.readNoEof())) < 0) {
        }
        return this.symbolValues[index];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.symbolCodeBits.length; ++i) {
            sb.append(String.format("Code %s: Symbol %d%n", Integer.toBinaryString(this.symbolCodeBits[i]).substring(1), this.symbolValues[i]));
        }
        return sb.toString();
    }
}

