/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.legacy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.CreoleHorizontalLine;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyle;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomImg;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomMath;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomOpenIcon;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomSpace;
import znaishaded.net.sourceforge.plantuml.creole.atom.AtomSprite;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleColorAndSizeChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleColorChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleExposantChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleFontFamilyChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleImg;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleLatex;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleMath;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleMonospaced;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleOpenIcon;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleQrcode;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSizeChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSpace;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSprite;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleStyle;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleSvgAttributeChange;
import znaishaded.net.sourceforge.plantuml.creole.command.CommandCreoleUrl;
import znaishaded.net.sourceforge.plantuml.creole.legacy.AtomText;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontPosition;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.ImgValign;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;
import znaishaded.net.sourceforge.plantuml.openiconic.OpenIcon;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

public class StripeSimple
implements Stripe {
    private final Atom header;
    private final List<Atom> atoms = new ArrayList<Atom>();
    private final List<Command> commands = new ArrayList<Command>();
    private HorizontalAlignment align = HorizontalAlignment.LEFT;
    private FontConfiguration fontConfiguration;
    private final StripeStyle style;
    private final ISkinSimple skinParam;

    public void setCellAlignment(HorizontalAlignment align) {
        this.align = align;
    }

    public HorizontalAlignment getCellAlignment() {
        return this.align;
    }

    public String toString() {
        return super.toString() + " " + this.atoms.toString();
    }

    @Override
    public Atom getLHeader() {
        return this.header;
    }

    public StripeSimple(FontConfiguration fontConfiguration, StripeStyle style, CreoleContext context, ISkinSimple skinParam, CreoleMode modeSimpleLine) {
        this.fontConfiguration = fontConfiguration;
        this.style = style;
        this.skinParam = skinParam;
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.PLAIN));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.PLAIN));
        if (modeSimpleLine == CreoleMode.FULL) {
            this.commands.add(CommandCreoleStyle.createCreole(FontStyle.UNDERLINE));
        }
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.UNDERLINE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.UNDERLINE));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.BACKCOLOR));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.BACKCOLOR));
        this.commands.add(CommandCreoleSizeChange.create());
        this.commands.add(CommandCreoleSizeChange.createEol());
        this.commands.add(CommandCreoleColorChange.create());
        this.commands.add(CommandCreoleColorChange.createEol());
        this.commands.add(CommandCreoleColorAndSizeChange.create());
        this.commands.add(CommandCreoleColorAndSizeChange.createEol());
        this.commands.add(CommandCreoleExposantChange.create(FontPosition.EXPOSANT));
        this.commands.add(CommandCreoleExposantChange.create(FontPosition.INDICE));
        this.commands.add(CommandCreoleImg.create());
        this.commands.add(CommandCreoleQrcode.create());
        this.commands.add(CommandCreoleOpenIcon.create(skinParam.getIHtmlColorSet()));
        this.commands.add(CommandCreoleMath.create());
        this.commands.add(CommandCreoleLatex.create());
        this.commands.add(CommandCreoleSprite.create(skinParam.getIHtmlColorSet()));
        this.commands.add(CommandCreoleSpace.create());
        this.commands.add(CommandCreoleFontFamilyChange.create());
        this.commands.add(CommandCreoleFontFamilyChange.createEol());
        this.commands.add(CommandCreoleMonospaced.create(skinParam.getMonospacedFamily()));
        this.commands.add(CommandCreoleUrl.create(skinParam));
        if (SecurityUtils.allowSvgText()) {
            this.commands.add(CommandCreoleSvgAttributeChange.create());
        }
        this.header = style.getHeader(fontConfiguration, context);
        if (this.header != null) {
            this.atoms.add(this.header);
        }
    }

    @Override
    public List<Atom> getAtoms() {
        if (this.atoms.size() == 0) {
            this.atoms.add(AtomText.create(" ", this.fontConfiguration));
        }
        return Collections.unmodifiableList(this.atoms);
    }

    public FontConfiguration getActualFontConfiguration() {
        return this.fontConfiguration;
    }

    public void setActualFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    public void analyzeAndAdd(String line) {
        if (line == null) {
            throw new IllegalArgumentException();
        }
        if (line.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(line);
        }
        line = CharHidder.hide(line);
        if (this.style.getType() == StripeStyleType.HEADING) {
            this.fontConfiguration = StripeSimple.fontConfigurationForHeading(this.fontConfiguration, this.style.getOrder());
            this.modifyStripe(line);
        } else if (this.style.getType() == StripeStyleType.HORIZONTAL_LINE) {
            this.atoms.add(CreoleHorizontalLine.create(this.fontConfiguration, line, this.style.getStyle(), this.skinParam));
        } else {
            this.modifyStripe(line);
        }
    }

    private static FontConfiguration fontConfigurationForHeading(FontConfiguration fontConfiguration, int order) {
        fontConfiguration = order == 0 ? fontConfiguration.bigger(4.0).bold() : (order == 1 ? fontConfiguration.bigger(2.0).bold() : (order == 2 ? fontConfiguration.bigger(1.0).bold() : fontConfiguration.italic()));
        return fontConfiguration;
    }

    public void addImage(String src, double scale) {
        this.atoms.add(AtomImg.create(src, ImgValign.TOP, 0, scale, null));
    }

    public void addQrcode(String src, double scale) {
        this.atoms.add(AtomImg.createQrcode(src, scale));
    }

    public void addSpace(int size) {
        this.atoms.add(AtomSpace.create(size));
    }

    public void addUrl(Url url) {
        this.atoms.add(AtomText.createUrl(url, this.fontConfiguration, this.skinParam));
    }

    public void addSprite(String src, double scale, HColor color) {
        Sprite sprite = this.skinParam.getSprite(src);
        if (sprite != null) {
            this.atoms.add(new AtomSprite(color, scale, this.fontConfiguration, sprite, null));
        }
    }

    public void addOpenIcon(String src, double scale, HColor color) {
        OpenIcon openIcon = OpenIcon.retrieve(src);
        if (openIcon != null) {
            this.atoms.add(new AtomOpenIcon(color, scale, openIcon, this.fontConfiguration, null));
        }
    }

    public void addMath(ScientificEquationSafe math) {
        this.atoms.add(new AtomMath(math, this.fontConfiguration.getColor(), this.fontConfiguration.getExtendedColor(), this.skinParam.getColorMapper()));
    }

    private void modifyStripe(String line) {
        StringBuilder pending = new StringBuilder();
        while (line.length() > 0) {
            Command cmd = this.searchCommand(line);
            if (cmd == null) {
                pending.append(line.charAt(0));
                line = line.substring(1);
                continue;
            }
            this.addPending(pending);
            line = cmd.executeAndGetRemaining(line, this);
        }
        this.addPending(pending);
    }

    private void addPending(StringBuilder pending) {
        if (pending.length() == 0) {
            return;
        }
        this.atoms.add(AtomText.create(pending.toString(), this.fontConfiguration));
        pending.setLength(0);
    }

    private Command searchCommand(String line) {
        for (Command cmd : this.commands) {
            int i = cmd.matchingSize(line);
            if (i == 0) continue;
            return cmd;
        }
        return null;
    }
}

