/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

class UnlinearCompression {
    private final double inner;
    private final double outer;

    public UnlinearCompression(double inner, double outer) {
        this.inner = inner;
        this.outer = outer;
    }

    public double compress(double x) {
        double pour;
        double pourInter;
        if ((x -= (pourInter = Math.floor(pour = x / (this.inner + this.outer))) * (this.inner + this.outer)) < this.inner) {
            return pourInter * this.outer;
        }
        return x - this.inner + pourInter * this.outer;
    }

    public double uncompress(double x, Rounding rounding) {
        int pourInter = this.nbOuterBefore(x);
        boolean onBorder = UnlinearCompression.equals(x, (double)pourInter * this.outer);
        if (!onBorder || rounding != Rounding.BORDER_1) {
            x = onBorder && rounding == Rounding.CENTRAL ? (x += this.inner / 2.0) : (x += this.inner);
        }
        return x += (double)pourInter * this.inner;
    }

    private static boolean equals(double d1, double d2) {
        return Math.abs(d1 - d2) < 0.001;
    }

    private int nbOuterBefore(double x) {
        double pour = x / this.outer;
        int pourInter = (int)Math.floor(pour);
        return pourInter;
    }

    public double[] encounteredSingularities(double from, double to) {
        double[] result;
        int outer1 = this.nbOuterBefore(from) + 1;
        int outer2 = this.nbOuterBefore(to) + 1;
        if (UnlinearCompression.equals(to, (double)(outer2 - 1) * this.outer)) {
            --outer2;
        }
        if (from <= to) {
            result = new double[outer2 - outer1];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (double)(outer1 + i) * this.outer;
            }
        } else {
            result = new double[outer1 - outer2];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (double)(outer1 - 1 - i) * this.outer;
            }
        }
        return result;
    }

    public double innerSize() {
        return this.inner;
    }

    static enum Rounding {
        BORDER_1,
        CENTRAL,
        BORDER_2;

    }
}

