/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementText;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementTreeEntry;
import znaishaded.net.sourceforge.plantuml.salt.element.Grid2;
import znaishaded.net.sourceforge.plantuml.salt.element.ListWidth;
import znaishaded.net.sourceforge.plantuml.salt.element.Skeleton;
import znaishaded.net.sourceforge.plantuml.salt.element.TableStrategy;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ElementTree
extends AbstractElement {
    private final List<ElementTreeEntry> entries = new ArrayList<ElementTreeEntry>();
    private final UFont font;
    private final ISkinSimple spriteContainer;
    private final double margin = 10.0;
    private final TableStrategy strategy;

    public ElementTree(UFont font, ISkinSimple spriteContainer, TableStrategy strategy) {
        this.font = font;
        this.spriteContainer = spriteContainer;
        this.strategy = strategy;
    }

    public void addEntry(String s2) {
        int level = 0;
        while (s2.startsWith("+")) {
            ++level;
            s2 = s2.substring(1);
        }
        ElementText elmt = new ElementText(Arrays.asList(StringUtils.trin(s2)), this.font, this.spriteContainer);
        this.entries.add(new ElementTreeEntry(level, elmt));
    }

    public void addCellToEntry(String s2) {
        int size = this.entries.size();
        if (size > 0) {
            ElementText elmt = new ElementText(Arrays.asList(StringUtils.trin(s2)), this.font, this.spriteContainer);
            this.entries.get(size - 1).addCell(elmt);
        }
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        double w1 = 0.0;
        double h2 = 0.0;
        for (ElementTreeEntry entry : this.entries) {
            Dimension2D dim1 = entry.getPreferredDimensionFirstCell(stringBounder);
            w1 = Math.max(w1, dim1.getWidth());
            h2 += dim1.getHeight();
        }
        double w2 = this.getWidthOther(stringBounder).getTotalWidthWithMargin(10.0);
        if (w2 > 0.0) {
            w2 += 10.0;
        }
        return new Dimension2DDouble(w1 + w2 + 2.0, h2);
    }

    private ListWidth getWidthOther(StringBounder stringBounder) {
        ListWidth merge = new ListWidth();
        for (ElementTreeEntry entry : this.entries) {
            ListWidth dim2 = entry.getPreferredDimensionOtherCell(stringBounder);
            merge = merge.mergeMax(dim2);
        }
        return merge;
    }

    private double getWidth1(StringBounder stringBounder) {
        double w1 = 0.0;
        for (ElementTreeEntry entry : this.entries) {
            Dimension2D dim1 = entry.getPreferredDimensionFirstCell(stringBounder);
            w1 = Math.max(w1, dim1.getWidth());
        }
        return w1;
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double w1 = this.getWidth1(stringBounder);
        ListWidth otherWidth = this.getWidthOther(stringBounder);
        Skeleton skeleton = new Skeleton();
        double yvar = 0.0;
        ArrayList<Double> rows = new ArrayList<Double>();
        ArrayList<Double> cols = new ArrayList<Double>();
        rows.add(yvar);
        double xvar = 0.0;
        cols.add(xvar);
        cols.add(xvar += w1 + 5.0);
        Iterator<Object> it = otherWidth.iterator();
        while (it.hasNext()) {
            cols.add(xvar += it.next() + 10.0);
        }
        for (ElementTreeEntry entry : this.entries) {
            entry.drawFirstCell(ug, 0.0, yvar);
            entry.drawSecondCell(ug, w1 + 10.0, yvar, otherWidth, 10.0);
            double h2 = entry.getPreferredDimensionFirstCell(stringBounder).getHeight();
            skeleton.add(entry.getXDelta() - 7.0, yvar + h2 / 2.0 - 1.0);
            rows.add(yvar += h2);
        }
        ug = ug.apply(HColorSet.instance().getColorIfValid("#888888"));
        skeleton.draw(ug, 0.0, 0.0);
        if (this.strategy != TableStrategy.DRAW_NONE) {
            Grid2 grid = new Grid2(rows, cols, this.strategy);
            grid.drawU(ug);
        }
    }
}

