/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class ReferenceTile
extends AbstractTile
implements Tile {
    private final Reference reference;
    private final TileArguments tileArguments;
    private Real first;
    private Real last;

    @Override
    public Event getEvent() {
        return this.reference;
    }

    public ReferenceTile(Reference reference, TileArguments tileArguments) {
        this.reference = reference;
        this.tileArguments = tileArguments;
    }

    private void init(StringBounder stringBounder) {
        if (this.first != null) {
            return;
        }
        for (Participant p : this.reference.getParticipant()) {
            LivingSpace livingSpace = this.tileArguments.getLivingSpace(p);
            Real pos = livingSpace.getPosC(stringBounder);
            if (this.first == null || pos.getCurrentValue() < this.first.getCurrentValue()) {
                this.first = livingSpace.getPosB();
            }
            if (this.last != null && !(pos.getCurrentValue() > this.last.getCurrentValue())) continue;
            this.last = livingSpace.getPosD(stringBounder);
        }
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        if (this.reference.getParticipant().size() == 1) {
            this.last = this.last.addAtLeast(0.0);
        }
        this.last.ensureBiggerThan(this.first.addFixed(dim.getWidth()));
    }

    private Component getComponent(StringBounder stringBounder) {
        Display strings = Display.empty();
        strings = strings.add("ref");
        strings = strings.addAll(this.reference.getStrings());
        Component comp = this.tileArguments.getSkin().createComponent(null, ComponentType.REFERENCE, null, this.tileArguments.getSkinParam(), strings);
        return comp;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.init(stringBounder);
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        Area area = new Area(this.last.getCurrentValue() - this.first.getCurrentValue(), dim.getHeight());
        ug = ug.apply(UTranslate.dx(this.first.getCurrentValue()));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getHeight();
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.first;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        this.init(stringBounder);
        return this.last;
    }
}

