/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;

public class DriverPolygonSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        UPolygon shape = (UPolygon)ushape;
        double[] points = shape.getPointArray(x, y);
        assert (points.length % 2 == 0);
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            for (int j = 0; j < points.length; j += 2) {
                if (clip.isInside(points[j], points[j + 1])) continue;
                return;
            }
        }
        String color = mapper.toSvg(param.getColor());
        HColor back = param.getBackcolor();
        if (back instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)back;
            String id = svg.createSvgGradient(mapper.toRGB(gr.getColor1()), mapper.toRGB(gr.getColor2()), gr.getPolicy());
            svg.setFillColor("url(#" + id + ")");
        } else {
            String backcolorString = mapper.toSvg(back);
            svg.setFillColor(backcolorString);
        }
        svg.setStrokeColor(color);
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        svg.svgPolygon(shape.getDeltaShadow(), points);
    }
}

