/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.version;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.command.PSystemSingleLineFactory;
import znaishaded.net.sourceforge.plantuml.security.SecurityProfile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.version.PSystemKeycheck;
import znaishaded.net.sourceforge.plantuml.version.PSystemKeygen;
import znaishaded.net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemVersionFactory
extends PSystemSingleLineFactory {
    @Override
    protected AbstractPSystem executeLine(String line) {
        try {
            Pattern p;
            Matcher m3;
            if (line.matches("(?i)^(authors?|about)\\s*$")) {
                return PSystemVersion.createShowAuthors();
            }
            if (line.matches("(?i)^version\\s*$")) {
                return PSystemVersion.createShowVersion();
            }
            if (line.matches("(?i)^stdlib\\s*$")) {
                return PSystemVersion.createStdLib();
            }
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE && line.matches("(?i)^path\\s*$")) {
                return PSystemVersion.createPath();
            }
            if (line.matches("(?i)^testdot\\s*$")) {
                return PSystemVersion.createTestDot();
            }
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE && line.matches("(?i)^dumpstacktrace\\s*$")) {
                return PSystemVersion.createDumpStackTrace();
            }
            if (line.matches("(?i)^keydistributor\\s*$")) {
                return PSystemVersion.createKeyDistributor();
            }
            if (line.matches("(?i)^keygen\\s*$")) {
                line = line.trim();
                return new PSystemKeygen("");
            }
            if (line.matches("(?i)^keyimport(\\s+[0-9a-z]+)?\\s*$")) {
                line = line.trim();
                String key = line.substring("keyimport".length()).trim();
                return new PSystemKeygen(key);
            }
            if (line.matches("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$") && (m3 = (p = Pattern.compile("(?i)^keycheck\\s+([0-9a-z]+)\\s+([0-9a-z]+)\\s*$")).matcher(line)).find()) {
                return new PSystemKeycheck(m3.group(1), m3.group(2));
            }
        }
        catch (IOException e) {
            Log.error("Error " + e);
        }
        return null;
    }
}

