/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wbs;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.wbs.ITF;
import znaishaded.net.sourceforge.plantuml.wbs.ITFComposed;
import znaishaded.net.sourceforge.plantuml.wbs.WBSTextBlock;
import znaishaded.net.sourceforge.plantuml.wbs.WElement;

class Fork
extends WBSTextBlock {
    private final TextBlock main;
    private final List<ITF> right = new ArrayList<ITF>();
    private final double delta1x = 20.0;
    private final double deltay = 40.0;

    public Fork(ISkinParam skinParam, WElement idea) {
        super(skinParam, idea.getStyleBuilder(), idea.getLevel());
        if (idea.getLevel() != 0) {
            throw new IllegalArgumentException();
        }
        this.main = this.buildMain(idea);
        for (WElement child : idea.getChildren(Direction.RIGHT)) {
            this.right.add(ITFComposed.build2(skinParam, child));
        }
    }

    @Override
    public void drawU(UGraphic ug) {
        double firstX;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D fullDim = this.calculateDimension(stringBounder);
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        double dx = (fullDim.getWidth() - mainDim.getWidth()) / 2.0;
        this.main.drawU(ug.apply(UTranslate.dx(dx)));
        this.drawLine(ug, dx + mainDim.getWidth() / 2.0, mainDim.getHeight(), dx + mainDim.getWidth() / 2.0, mainDim.getHeight() + 20.0);
        double x = 0.0;
        double y = mainDim.getHeight() + 40.0;
        if (this.right.size() == 0) {
            return;
        }
        double lastX = firstX = this.right.get(0).getT1(stringBounder).getX();
        for (ITF child : this.right) {
            lastX = x + child.getT1(stringBounder).getX();
            this.drawLine(ug, lastX, mainDim.getHeight() + 20.0, lastX, y);
            child.drawU(ug.apply(new UTranslate(x, y)));
            x += child.calculateDimension(stringBounder).getWidth() + 20.0;
        }
        lastX = Math.max(lastX, dx + mainDim.getWidth() / 2.0);
        this.drawLine(ug, firstX, mainDim.getHeight() + 20.0, lastX, mainDim.getHeight() + 20.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (ITF child : this.right) {
            Dimension2D childDim = child.calculateDimension(stringBounder);
            height = Math.max(height, childDim.getHeight());
            width += childDim.getWidth();
        }
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        width = Math.max(width, mainDim.getWidth());
        return new Dimension2DDouble(width, height += mainDim.getHeight());
    }
}

