/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenCompoundParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndex;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndexCompound;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndexMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenIndexParser;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMember;
import org.testingisdocumenting.znai.doxygen.parser.DoxygenMembersList;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class Doxygen {
    public static Doxygen INSTANCE = new Doxygen();
    private static final String DOXYGEN_JSON_CFG_NAME = "doxygen.json";
    private static final String INDEX_PATH_KEY = "indexPath";
    private DoxygenIndex doxygenIndexCached;
    private Path indexPath;
    private FileTime indexLastModifiedTime;
    private final Map<String, DoxygenMember> memberByName = new ConcurrentHashMap<String, DoxygenMember>();
    private final Map<String, DoxygenCompound> compoundByName = new ConcurrentHashMap<String, DoxygenCompound>();

    private Doxygen() {
    }

    public Path getIndexPath() {
        return this.indexPath;
    }

    public DoxygenMember getCachedOrFindAndParseMember(ComponentsRegistry componentsRegistry, String fullName) {
        DoxygenMember cachedMember = this.memberByName.get(fullName);
        if (cachedMember != null) {
            return cachedMember;
        }
        DoxygenIndex doxygenIndex = this.buildIndexOrGetCached(componentsRegistry);
        DoxygenIndexMember indexMember = doxygenIndex.findMemberByName(fullName);
        if (indexMember == null) {
            return null;
        }
        DoxygenCompound compound = this.getCachedOrFindAndParseCompound(componentsRegistry, indexMember.getCompound().getName());
        return compound.findByFullName(fullName);
    }

    public DoxygenMembersList findAndParseAllMembers(ComponentsRegistry componentsRegistry, String fullName) {
        DoxygenIndex doxygenIndex = this.buildIndexOrGetCached(componentsRegistry);
        List<DoxygenIndexMember> indexMembersList = doxygenIndex.findAllMembersByName(fullName);
        if (indexMembersList.isEmpty()) {
            return new DoxygenMembersList();
        }
        return new DoxygenMembersList(indexMembersList.stream().map(indexMember -> {
            DoxygenCompound compound = this.getCachedOrFindAndParseCompound(componentsRegistry, indexMember.getCompound().getName());
            return compound.findById(indexMember.getId());
        }));
    }

    public DoxygenCompound getCachedOrFindAndParseCompound(ComponentsRegistry componentsRegistry, String fullName) {
        DoxygenCompound cachedCompound = this.compoundByName.get(fullName);
        if (cachedCompound != null) {
            return cachedCompound;
        }
        DoxygenIndex doxygenIndex = this.buildIndexOrGetCached(componentsRegistry);
        DoxygenIndexCompound indexCompound = doxygenIndex.findCompoundByName(fullName);
        if (indexCompound == null) {
            return null;
        }
        DoxygenCompound compound = this.findAndParseCompound(componentsRegistry, indexCompound);
        this.compoundByName.put(fullName, compound);
        return compound;
    }

    public DoxygenIndex buildIndexOrGetCached(ComponentsRegistry componentsRegistry) {
        FileTime indexModifiedTime;
        if (this.indexPath != null && (indexModifiedTime = FileUtils.getLastModifiedTime(this.indexPath)).equals(this.indexLastModifiedTime)) {
            return this.doxygenIndexCached;
        }
        this.buildIndex(componentsRegistry);
        this.memberByName.clear();
        this.compoundByName.clear();
        return this.doxygenIndexCached;
    }

    private void buildIndex(ComponentsRegistry componentsRegistry) {
        if (this.indexPath == null) {
            this.indexPath = this.extractDoxygenIndexPath(componentsRegistry);
        }
        String indexXml = FileUtils.fileTextContent(this.indexPath);
        this.doxygenIndexCached = DoxygenIndexParser.parse(indexXml);
        this.indexLastModifiedTime = FileUtils.getLastModifiedTime(this.indexPath);
    }

    private DoxygenCompound findAndParseCompound(ComponentsRegistry componentsRegistry, DoxygenIndexCompound indexCompound) {
        String xml = FileUtils.fileTextContent(this.indexPath.getParent().resolve(indexCompound.getId() + ".xml"));
        return DoxygenCompoundParser.parse(componentsRegistry, xml, indexCompound.getId());
    }

    private Path extractDoxygenIndexPath(ComponentsRegistry componentsRegistry) {
        Path docRoot = componentsRegistry.docConfig().getDocRoot();
        Path cfgPath = docRoot.resolve(DOXYGEN_JSON_CFG_NAME).toAbsolutePath();
        if (!Files.exists(cfgPath, new LinkOption[0])) {
            throw new IllegalArgumentException("can't find doxygen.json config file");
        }
        Map<String, ?> cfg = JsonUtils.deserializeAsMap(FileUtils.fileTextContent(cfgPath));
        Object indexPath = cfg.get(INDEX_PATH_KEY);
        if (indexPath == null) {
            throw new IllegalArgumentException("can't find indexPath key that points to doxygen index.xml");
        }
        return docRoot.resolve(indexPath.toString());
    }
}

