/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.charts;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.table.CsvTableParser;

public class ChartIncludePlugin
implements IncludePlugin {
    private Path fullPath;

    @Override
    public String id() {
        return "chart";
    }

    @Override
    public IncludePlugin create() {
        return new ChartIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.fullPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        String textContent = componentsRegistry.resourceResolver().textContent(this.fullPath);
        Map<String, Object> table = CsvTableParser.parse(textContent).toMap();
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        props.put("chartType", props.get("type"));
        props.put("data", table.get("data"));
        return PluginResult.docElement("Chart", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.fullPath));
    }
}

