/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.cli.CliCommandPropsAndValidation;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class CliFencePlugin
implements FencePlugin {
    private List<String> commands;

    @Override
    public String id() {
        return "cli";
    }

    @Override
    public FencePlugin create() {
        return new CliFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        this.commands = Arrays.stream(content.split("\n")).map(String::trim).filter(line -> !line.isEmpty()).collect(Collectors.toList());
        Stream<DocElement> docElementStream = this.commands.stream().map(command -> {
            Map<String, Object> props = CliCommandPropsAndValidation.createProps(command, content, pluginParams.getOpts());
            DocElement cliCommand = new DocElement("CliCommand");
            props.forEach(cliCommand::addProp);
            return cliCommand;
        });
        return PluginResult.docElements(docElementStream);
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.HIGH.text(String.join((CharSequence)" ", this.commands));
    }
}

