/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.testingisdocumenting.webtau.Matchers;
import org.testingisdocumenting.webtau.WebTauCore;
import org.testingisdocumenting.znai.extensions.include.PluginsTestUtils;
import znaishaded.org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileIncludePluginTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FileIncludePluginTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void should extract file snippet based on start line and number of lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', numberOfLines: 2}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', numberOfLines: 2}");
            text = string;
        }
        callSiteArray[1].call(text, callSiteArray[2].callStatic(WebTauCore.class, callSiteArray[3].call((Object)"a multiple lines\n", (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[4].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', endLine: 'stop'}");
            text = string;
        }
        callSiteArray[5].call(text, callSiteArray[6].callStatic(WebTauCore.class, callSiteArray[7].call(callSiteArray[8].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should extract not match start line to the end line pattern but start from the one below() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[9].callStatic(FileIncludePluginTest.class, (Object)"file-with-similar-lines.txt", (Object)"{startLine: '$prompt >', endLine: '$prompt >'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-similar-lines.txt", "{startLine: '$prompt >', endLine: '$prompt >'}");
            text = string;
        }
        callSiteArray[10].call(text, callSiteArray[11].callStatic(WebTauCore.class, callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call((Object)"$prompt >\n", (Object)"some output\n"), (Object)"goes here\n"), (Object)"$prompt >")));
    }

    @Test
    public void should validate start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_start_and_stop_end_lines_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: '1multiple lines', endLine: 'stop'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[15].call(callSiteArray[16].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure1(this, this)), callSiteArray[17].callStatic(Matchers.class, callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].call((Object)"there is no line containing \"1multiple lines\" in <file.txt>:\n", (Object)"this is a\n"), (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
        public final class _should_validate_start_and_stop_end_lines_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop2'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[25].call(callSiteArray[26].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure2(this, this)), callSiteArray[27].callStatic(Matchers.class, callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call((Object)"there is no line containing \"stop2\" in <file.txt>:\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines excluding them() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[33].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[34].call(text, callSiteArray[35].callStatic(WebTauCore.class, (Object)""));
    }

    @Test
    public void should extract file snippet based on surrounding pattern and exclude the pattern() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[36].callStatic(FileIncludePluginTest.class, (Object)"file-with-surround-marker.txt", (Object)"{surroundedBy: '# concept-example'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-surround-marker.txt", "{surroundedBy: '# concept-example'}");
            text = string;
        }
        callSiteArray[37].call(text, callSiteArray[38].callStatic(WebTauCore.class, callSiteArray[39].call((Object)"foo()\n", (Object)"bar()")));
    }

    @Test
    public void should extract file snippet based on multiple surrounding patterns and indent each block() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[40].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", (Object)"{surroundedBy: ['# import-list', '# concept-example']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-multiple-surround-marker.txt", "{surroundedBy: ['# import-list', '# concept-example']}");
            text = string;
        }
        callSiteArray[41].call(text, callSiteArray[42].callStatic(WebTauCore.class, callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call((Object)"import abc\n", (Object)"import def\n"), (Object)"foo()\n"), (Object)"bar()")));
    }

    @Test
    public void should extract file snippet based on multiple surrounding patterns and add specified separator() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = callSiteArray[46].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", callSiteArray[47].call((Object)"{surroundedBy: ['# import-list', '# concept-example', '# another-example', '# next-last-example', '# last-example', ],", (Object)" surroundedBySeparator: ['...', '', '%']}"));
        callSiteArray[48].call(text, callSiteArray[49].callStatic(WebTauCore.class, callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call((Object)"import abc\n", (Object)"import def\n"), (Object)"...\n"), (Object)"foo()\n"), (Object)"bar()\n"), (Object)"\n"), (Object)"foobar()\n"), (Object)"%\n"), (Object)"almostFinish()\n"), (Object)"%\n"), (Object)"finish()")));
    }

    @Test
    public void should replace text by exact match() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[60].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: ['foo', 'foo2']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: ['foo', 'foo2']}");
            text = string;
        }
        callSiteArray[61].call(text, callSiteArray[62].callStatic(WebTauCore.class, callSiteArray[63].call(callSiteArray[64].call((Object)"foo2 foo2 foo2\n", (Object)"bar bar bar\n"), (Object)"test12 great16")));
    }

    @Test
    public void should replace text by exact match using multiple pairs() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[65].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: [['foo', 'foo2'], ['bar', 'bar3']]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: [['foo', 'foo2'], ['bar', 'bar3']]}");
            text = string;
        }
        callSiteArray[66].call(text, callSiteArray[67].callStatic(WebTauCore.class, callSiteArray[68].call(callSiteArray[69].call((Object)"foo2 foo2 foo2\n", (Object)"bar3 bar3 bar3\n"), (Object)"test12 great16")));
    }

    @Test
    public void should replace text using match group() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[70].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: ['test(\\\\d+)', '$1-TEST']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: ['test(\\\\d+)', '$1-TEST']}");
            text = string;
        }
        callSiteArray[71].call(text, callSiteArray[72].callStatic(WebTauCore.class, callSiteArray[73].call(callSiteArray[74].call((Object)"foo foo foo\n", (Object)"bar bar bar\n"), (Object)"12-TEST great16")));
    }

    @Test
    public void should replace text inside surroundBy extracted group() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[75].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", (Object)"{surroundedBy: ['# import-list', '# concept-example'], replace: [['abc', 'ABC'], ['bar', 'Bar']]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-multiple-surround-marker.txt", "{surroundedBy: ['# import-list', '# concept-example'], replace: [['abc', 'ABC'], ['bar', 'Bar']]}");
            text = string;
        }
        callSiteArray[76].call(text, callSiteArray[77].callStatic(WebTauCore.class, callSiteArray[78].call(callSiteArray[79].call(callSiteArray[80].call((Object)"import ABC\n", (Object)"import def\n"), (Object)"foo()\n"), (Object)"Bar()")));
    }

    @Test
    public void should validate replace parameters() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        String expectedError = "replace expects list with two values [from, to] or a list of pairs [[from1, to1], [from2, to2]]";
        public final class _should_validate_replace_parameters_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_parameters_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: 'a'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_parameters_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_parameters_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_parameters_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[81].call(callSiteArray[82].callStatic(Matchers.class, (Object)new _should_validate_replace_parameters_closure3(this, this)), callSiteArray[83].callStatic(Matchers.class, (Object)expectedError));
        public final class _should_validate_replace_parameters_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_parameters_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure4.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: ['a']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_parameters_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_parameters_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_parameters_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[84].call(callSiteArray[85].callStatic(Matchers.class, (Object)new _should_validate_replace_parameters_closure4(this, this)), callSiteArray[86].callStatic(Matchers.class, (Object)expectedError));
        public final class _should_validate_replace_parameters_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_parameters_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure5.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: [['a']]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_parameters_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_parameters_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_parameters_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[87].call(callSiteArray[88].callStatic(Matchers.class, (Object)new _should_validate_replace_parameters_closure5(this, this)), callSiteArray[89].callStatic(Matchers.class, (Object)expectedError));
    }

    @Test
    public void should validate replace actually replaced something() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_replace_actually_replaced_something_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_actually_replaced_something_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure6.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: ['no-match', 'new-value']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_actually_replaced_something_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_actually_replaced_something_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_actually_replaced_something_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[90].call(callSiteArray[91].callStatic(Matchers.class, (Object)new _should_validate_replace_actually_replaced_something_closure6(this, this)), callSiteArray[92].callStatic(Matchers.class, (Object)"content was not modified using replace from: <no-match> to: <new-value>"));
    }

    @Test
    public void should extract file and exclude first and last line when excludeStartEnd is set and no start end is set() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[93].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[94].call(text, callSiteArray[95].callStatic(WebTauCore.class, callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five")));
    }

    @Test
    public void should extract file snippet based on start line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[100].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines'}");
            text = string;
        }
        callSiteArray[101].call(text, callSiteArray[102].callStatic(WebTauCore.class, callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start line and exclude only start() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[107].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'this is a', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'this is a', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[108].call(text, callSiteArray[109].callStatic(WebTauCore.class, callSiteArray[110].call(callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on end line and exclude only end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[115].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: '--- stop', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: '--- stop', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[116].call(text, callSiteArray[117].callStatic(WebTauCore.class, callSiteArray[118].call(callSiteArray[119].call(callSiteArray[120].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on end line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[121].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: 'stop'}");
            text = string;
        }
        callSiteArray[122].call(text, callSiteArray[123].callStatic(WebTauCore.class, callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].call(callSiteArray[127].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should automatically strip extra indentation() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[128].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{startLine: 'class', endLine: '}', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{startLine: 'class', endLine: '}', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[129].call(text, callSiteArray[130].callStatic(WebTauCore.class, callSiteArray[131].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should only include lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object singleImport = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            singleImport = object = callSiteArray[132].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import.*ClassName'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import.*ClassName'}");
            singleImport = string;
        }
        callSiteArray[133].call(singleImport, callSiteArray[134].callStatic(WebTauCore.class, (Object)"import a.b.c.ClassName"));
        Object allImports = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            allImports = object = callSiteArray[135].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import'}");
            allImports = string;
        }
        callSiteArray[136].call(allImports, callSiteArray[137].callStatic(WebTauCore.class, callSiteArray[138].call((Object)"import e.d.g.AnotherName\n", (Object)"import a.b.c.ClassName")));
    }

    @Test
    public void should only include lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[139].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: ['int', 'def']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: ['int', 'def']}");
            result = string;
        }
        callSiteArray[140].call(result, callSiteArray[141].callStatic(WebTauCore.class, callSiteArray[142].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should fail if none of the include regexps matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_include_regexps_matches_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_include_regexps_matches_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure7.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{includeRegexp: ['in2t', 'de2f']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_include_regexps_matches_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_include_regexps_matches_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[143].call(callSiteArray[144].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_include_regexps_matches_closure7(this, this)), callSiteArray[145].callStatic(Matchers.class, callSiteArray[146].call(callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].call(callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call((Object)"there are no lines matching includeRegexp <in2t>, <de2f> in <script.groovy>:\n", (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should exclude lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[153].callStatic(FileIncludePluginTest.class, (Object)"sample-with-marker.py", (Object)"{excludeRegexp: '# exa..le'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-marker.py", "{excludeRegexp: '# exa..le'}");
            withoutMarkers = string;
        }
        callSiteArray[154].call(withoutMarkers, callSiteArray[155].callStatic(WebTauCore.class, (Object)"print(\"hello\")"));
    }

    @Test
    public void should exclude lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[156].callStatic(FileIncludePluginTest.class, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-multi-marker.py", "{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
            withoutMarkers = string;
        }
        callSiteArray[157].call(withoutMarkers, callSiteArray[158].callStatic(WebTauCore.class, callSiteArray[159].call(callSiteArray[160].call((Object)"print(\"hello\")\n", (Object)"\n"), (Object)"print(\"hello world\")")));
    }

    @Test
    public void should fail if none of the exclude regexp matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_exclude_regexp_matches_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_exclude_regexp_matches_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure8.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# exam34ple\", \"# .roc3edur.\"]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_exclude_regexp_matches_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_exclude_regexp_matches_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[161].call(callSiteArray[162].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_exclude_regexp_matches_closure8(this, this)), callSiteArray[163].callStatic(Matchers.class, callSiteArray[164].call(callSiteArray[165].call(callSiteArray[166].call(callSiteArray[167].call(callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].call((Object)"there are no lines matching excludeRegexp <# exam34ple>, <# .roc3edur.> in <sample-with-multi-marker.py>:\n", (Object)"# example: how to print\n"), (Object)"print(\"hello\")\n"), (Object)"# example-end\n"), (Object)"\n"), (Object)"# procedure: how to print\n"), (Object)"print(\"hello world\")\n"), (Object)"# procedure-end")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a line idx() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[171].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 3}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 3}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 7}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[172].call(callSiteArray[173].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure9(this, this)), callSiteArray[174].callStatic(Matchers.class, callSiteArray[175].call((Object)"highlight idx is out of range: 7\n", (Object)"check: script.groovy")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[176].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'def a'}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 'def a'}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 'def c'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[177].call(callSiteArray[178].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure10(this, this)), callSiteArray[179].callStatic(Matchers.class, callSiteArray[180].call(callSiteArray[181].call(callSiteArray[182].call(callSiteArray[183].call(callSiteArray[184].call(callSiteArray[185].call(callSiteArray[186].call(callSiteArray[187].call((Object)"highlight text <def c> is not found\n", (Object)"check: script.groovy\n"), (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should highlight lines based on contains() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[188].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'class'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlight: 'class'}");
            props = map;
        }
        callSiteArray[189].call(callSiteArray[190].callGetProperty(props), callSiteArray[191].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{3})));
    }

    @Test
    public void should highlight lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[192].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlightPath: 'highlight.txt'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlightPath: 'highlight.txt'}");
            props = map;
        }
        callSiteArray[193].call(callSiteArray[194].callGetProperty(props), callSiteArray[195].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{4, 5})));
    }

    @Test
    public void when title is not set should auto generate title based file name() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[196].call(callSiteArray[197].callGetProperty(callSiteArray[198].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: true}")), callSiteArray[199].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[200].call(callSiteArray[201].callGetProperty(callSiteArray[202].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: false}")), callSiteArray[203].callStatic(WebTauCore.class, null));
        } else {
            callSiteArray[204].call(callSiteArray[205].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: true}")), callSiteArray[206].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[207].call(callSiteArray[208].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: false}")), callSiteArray[209].callStatic(WebTauCore.class, null));
        }
    }

    @Test
    public void should not allow autoTitle and title() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_not_allow_autoTitle_and_title_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_not_allow_autoTitle_and_title_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure11.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{title: 'hello', autoTitle: false}")), callSiteArray[3].callStatic(WebTauCore.class, null));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_not_allow_autoTitle_and_title_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "should";
                stringArray[1] = "title";
                stringArray[2] = "resultingProps";
                stringArray[3] = "equal";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _should_not_allow_autoTitle_and_title_closure11.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_should_not_allow_autoTitle_and_title_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_not_allow_autoTitle_and_title_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[210].call(callSiteArray[211].callStatic(Matchers.class, (Object)new _should_not_allow_autoTitle_and_title_closure11(this, this)), callSiteArray[212].callStatic(Matchers.class, (Object)"Can't have both <title> and <autoTitle> specified"));
    }

    @Test
    public void should validate lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_lines_from_a_highlight_text_file_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_lines_from_a_highlight_text_file_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure12.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlightPath: 'missing-highlight.txt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_lines_from_a_highlight_text_file_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingProps";
                return new CallSiteArray(_should_validate_lines_from_a_highlight_text_file_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[213].call(callSiteArray[214].callStatic(Matchers.class, (Object)new _should_validate_lines_from_a_highlight_text_file_closure12(this, this)), callSiteArray[215].callStatic(Matchers.class, ScriptBytecodeAdapter.bitwiseNegate((Object)"highlight text <def g> is not found")));
    }

    private static String resultingSnippet(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[216].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})));
    }

    private static Map<String, Object> resultingProps(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[217].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})), Map.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileIncludePluginTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "resultingSnippet";
        stringArray[1] = "should";
        stringArray[2] = "equal";
        stringArray[3] = "plus";
        stringArray[4] = "resultingSnippet";
        stringArray[5] = "should";
        stringArray[6] = "equal";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "resultingSnippet";
        stringArray[10] = "should";
        stringArray[11] = "equal";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "should";
        stringArray[16] = "code";
        stringArray[17] = "throwException";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "should";
        stringArray[26] = "code";
        stringArray[27] = "throwException";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "resultingSnippet";
        stringArray[34] = "should";
        stringArray[35] = "equal";
        stringArray[36] = "resultingSnippet";
        stringArray[37] = "should";
        stringArray[38] = "equal";
        stringArray[39] = "plus";
        stringArray[40] = "resultingSnippet";
        stringArray[41] = "should";
        stringArray[42] = "equal";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "plus";
        stringArray[46] = "resultingSnippet";
        stringArray[47] = "plus";
        stringArray[48] = "should";
        stringArray[49] = "equal";
        stringArray[50] = "plus";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "plus";
        stringArray[54] = "plus";
        stringArray[55] = "plus";
        stringArray[56] = "plus";
        stringArray[57] = "plus";
        stringArray[58] = "plus";
        stringArray[59] = "plus";
        stringArray[60] = "resultingSnippet";
        stringArray[61] = "should";
        stringArray[62] = "equal";
        stringArray[63] = "plus";
        stringArray[64] = "plus";
        stringArray[65] = "resultingSnippet";
        stringArray[66] = "should";
        stringArray[67] = "equal";
        stringArray[68] = "plus";
        stringArray[69] = "plus";
        stringArray[70] = "resultingSnippet";
        stringArray[71] = "should";
        stringArray[72] = "equal";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "resultingSnippet";
        stringArray[76] = "should";
        stringArray[77] = "equal";
        stringArray[78] = "plus";
        stringArray[79] = "plus";
        stringArray[80] = "plus";
        stringArray[81] = "should";
        stringArray[82] = "code";
        stringArray[83] = "throwException";
        stringArray[84] = "should";
        stringArray[85] = "code";
        stringArray[86] = "throwException";
        stringArray[87] = "should";
        stringArray[88] = "code";
        stringArray[89] = "throwException";
        stringArray[90] = "should";
        stringArray[91] = "code";
        stringArray[92] = "throwException";
        stringArray[93] = "resultingSnippet";
        stringArray[94] = "should";
        stringArray[95] = "equal";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "plus";
        stringArray[99] = "plus";
        stringArray[100] = "resultingSnippet";
        stringArray[101] = "should";
        stringArray[102] = "equal";
        stringArray[103] = "plus";
        stringArray[104] = "plus";
        stringArray[105] = "plus";
        stringArray[106] = "plus";
        stringArray[107] = "resultingSnippet";
        stringArray[108] = "should";
        stringArray[109] = "equal";
        stringArray[110] = "plus";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "resultingSnippet";
        stringArray[116] = "should";
        stringArray[117] = "equal";
        stringArray[118] = "plus";
        stringArray[119] = "plus";
        stringArray[120] = "plus";
        stringArray[121] = "resultingSnippet";
        stringArray[122] = "should";
        stringArray[123] = "equal";
        stringArray[124] = "plus";
        stringArray[125] = "plus";
        stringArray[126] = "plus";
        stringArray[127] = "plus";
        stringArray[128] = "resultingSnippet";
        stringArray[129] = "should";
        stringArray[130] = "equal";
        stringArray[131] = "plus";
        stringArray[132] = "resultingSnippet";
        stringArray[133] = "should";
        stringArray[134] = "equal";
        stringArray[135] = "resultingSnippet";
        stringArray[136] = "should";
        stringArray[137] = "equal";
        stringArray[138] = "plus";
        stringArray[139] = "resultingSnippet";
        stringArray[140] = "should";
        stringArray[141] = "equal";
        stringArray[142] = "plus";
        stringArray[143] = "should";
        stringArray[144] = "code";
        stringArray[145] = "throwException";
        stringArray[146] = "plus";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "plus";
        stringArray[150] = "plus";
        stringArray[151] = "plus";
        stringArray[152] = "plus";
        stringArray[153] = "resultingSnippet";
        stringArray[154] = "should";
        stringArray[155] = "equal";
        stringArray[156] = "resultingSnippet";
        stringArray[157] = "should";
        stringArray[158] = "equal";
        stringArray[159] = "plus";
        stringArray[160] = "plus";
        stringArray[161] = "should";
        stringArray[162] = "code";
        stringArray[163] = "throwException";
        stringArray[164] = "plus";
        stringArray[165] = "plus";
        stringArray[166] = "plus";
        stringArray[167] = "plus";
        stringArray[168] = "plus";
        stringArray[169] = "plus";
        stringArray[170] = "plus";
        stringArray[171] = "resultingSnippet";
        stringArray[172] = "should";
        stringArray[173] = "code";
        stringArray[174] = "throwException";
        stringArray[175] = "plus";
        stringArray[176] = "resultingSnippet";
        stringArray[177] = "should";
        stringArray[178] = "code";
        stringArray[179] = "throwException";
        stringArray[180] = "plus";
        stringArray[181] = "plus";
        stringArray[182] = "plus";
        stringArray[183] = "plus";
        stringArray[184] = "plus";
        stringArray[185] = "plus";
        stringArray[186] = "plus";
        stringArray[187] = "plus";
        stringArray[188] = "resultingProps";
        stringArray[189] = "should";
        stringArray[190] = "highlight";
        stringArray[191] = "equal";
        stringArray[192] = "resultingProps";
        stringArray[193] = "should";
        stringArray[194] = "highlight";
        stringArray[195] = "equal";
        stringArray[196] = "should";
        stringArray[197] = "title";
        stringArray[198] = "resultingProps";
        stringArray[199] = "equal";
        stringArray[200] = "should";
        stringArray[201] = "title";
        stringArray[202] = "resultingProps";
        stringArray[203] = "equal";
        stringArray[204] = "should";
        stringArray[205] = "title";
        stringArray[206] = "equal";
        stringArray[207] = "should";
        stringArray[208] = "title";
        stringArray[209] = "equal";
        stringArray[210] = "should";
        stringArray[211] = "code";
        stringArray[212] = "throwException";
        stringArray[213] = "should";
        stringArray[214] = "code";
        stringArray[215] = "throwException";
        stringArray[216] = "processAndGetSimplifiedCodeBlock";
        stringArray[217] = "processIncludeAndGetProps";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[218];
        FileIncludePluginTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileIncludePluginTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileIncludePluginTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

