/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.utils.StringUtils;

class TextContentExtractor {
    private TextContentExtractor() {
    }

    public static String extractText(String contentId, String content, PluginParamsOpts opts) {
        if (opts.isEmpty()) {
            return content;
        }
        Text text = new Text(contentId, content);
        Text surroundedBy = TextContentExtractor.cropSurroundedBy(contentId, text, opts);
        Text croppedAtStart = TextContentExtractor.cropStart(surroundedBy, opts);
        Text croppedAtEnd = TextContentExtractor.cropEnd(croppedAtStart, opts);
        Text replacedAll = TextContentExtractor.replaceAll(croppedAtEnd, opts);
        Text withExcludedStartEnd = TextContentExtractor.excludeStartEnd(replacedAll, opts);
        Text withIncludeRegexp = TextContentExtractor.includeRegexp(withExcludedStartEnd, opts);
        Text withExcludedRegexp = TextContentExtractor.excludeRegexp(withIncludeRegexp, opts);
        return withExcludedRegexp.stripIndentation().toString();
    }

    private static Text replaceAll(Text text, PluginParamsOpts opts) {
        List fromToOrListOfFromTo = opts.getList("replace");
        if (fromToOrListOfFromTo.isEmpty()) {
            return text;
        }
        ArrayList replacePairsList = new ArrayList();
        if (fromToOrListOfFromTo.get(0) instanceof List) {
            replacePairsList.addAll(fromToOrListOfFromTo);
        } else {
            replacePairsList.add(fromToOrListOfFromTo);
        }
        Text result = text;
        for (List fromTo : replacePairsList) {
            if (fromTo.size() != 2) {
                throw new IllegalArgumentException("replace expects list with two values [from, to] or a list of pairs [[from1, to1], [from2, to2]]");
            }
            result = result.replaceAll((String)fromTo.get(0), (String)fromTo.get(1));
        }
        return result;
    }

    private static Text cropSurroundedBy(String contentId, Text text, PluginParamsOpts opts) {
        List surroundedBy = opts.getList("surroundedBy");
        if (surroundedBy.isEmpty()) {
            return text;
        }
        List surroundedBySeparator = opts.getList("surroundedBySeparator");
        Iterator separatorIt = surroundedBySeparator.iterator();
        String separator = separatorIt.hasNext() ? (String)separatorIt.next() : null;
        Text result = new Text(contentId, "");
        int idx = 0;
        for (String marker : surroundedBy) {
            boolean isLast = idx == surroundedBy.size() - 1;
            Text surroundedCrop = text.startingWithLineContaining(marker);
            surroundedCrop = surroundedCrop.limitToLineContaining(marker).cropOneLineFromStartAndEnd();
            result = result.append(surroundedCrop.stripIndentation());
            if (!isLast && separator != null) {
                result = result.append(separator);
            }
            separator = separatorIt.hasNext() ? (String)separatorIt.next() : separator;
            ++idx;
        }
        return result;
    }

    private static Text cropStart(Text text, PluginParamsOpts opts) {
        String startLine = (String)opts.get("startLine");
        if (startLine == null) {
            return text;
        }
        return text.startingWithLineContaining(startLine);
    }

    private static Text cropEnd(Text text, PluginParamsOpts opts) {
        Number numberOfLines = (Number)opts.get("numberOfLines");
        if (numberOfLines != null) {
            return text.limitTo(numberOfLines);
        }
        String endLine = (String)opts.get("endLine");
        if (endLine != null) {
            return text.limitToLineContaining(endLine);
        }
        return text;
    }

    private static Text excludeStartEnd(Text text, PluginParamsOpts opts) {
        Boolean exclude = opts.get("excludeStartEnd", false);
        if (!exclude.booleanValue()) {
            return text;
        }
        boolean hasStartLine = opts.has("startLine");
        boolean hasEndLine = opts.has("endLine");
        if (hasStartLine && hasEndLine || !hasStartLine && !hasEndLine) {
            return text.cropOneLineFromStartAndEnd();
        }
        if (hasStartLine) {
            return text.cropOneLineFromStart();
        }
        return text.cropOneLineFromEnd();
    }

    private static Text includeRegexp(Text text, PluginParamsOpts opts) {
        List<String> includeRegexps = opts.getList("includeRegexp");
        if (includeRegexps.isEmpty()) {
            return text;
        }
        return text.includeRegexp(TextContentExtractor.createListOfPatterns(includeRegexps));
    }

    private static Text excludeRegexp(Text text, PluginParamsOpts opts) {
        List<String> excludeRegexps = opts.getList("excludeRegexp");
        if (excludeRegexps.isEmpty()) {
            return text;
        }
        return text.excludeRegexp(TextContentExtractor.createListOfPatterns(excludeRegexps));
    }

    private static List<Pattern> createListOfPatterns(List<String> regexps) {
        return regexps.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    private static class Text {
        private final String contentId;
        private final List<String> lines;
        private final boolean hasCroppedStart;

        public Text(String contentId, String text) {
            this(contentId, Arrays.asList(text.split("\n")), false);
        }

        public Text(String contentId, List<String> lines, boolean hasCroppedStart) {
            this.contentId = contentId;
            this.lines = lines;
            this.hasCroppedStart = hasCroppedStart;
        }

        Text stripIndentation() {
            return new Text(this.contentId, StringUtils.stripIndentation(this.toString()));
        }

        Text append(Text another) {
            ArrayList<String> newLines = new ArrayList<String>(this.lines);
            newLines.addAll(another.lines);
            return this.newText(newLines);
        }

        Text replaceAll(String from, String to) {
            List<String> replaced = this.lines.stream().map(line -> line.replaceAll(from, to)).collect(Collectors.toList());
            if (replaced.equals(this.lines)) {
                throw new IllegalArgumentException("content was not modified using replace from: <" + from + "> to: <" + to + ">");
            }
            return this.newText(replaced);
        }

        Text append(String line) {
            ArrayList<String> newLines = new ArrayList<String>(this.lines);
            newLines.add(line);
            return this.newText(newLines);
        }

        Text startingWithLineContaining(String subLine) {
            int lineIdx = this.findLineIdxContaining(subLine);
            return this.newText(this.lines.subList(lineIdx, this.lines.size()), true);
        }

        Text limitToLineContaining(String subLine) {
            int lineIdx = this.findLineIdxContaining(subLine);
            return this.newText(this.lines.subList(0, lineIdx + 1));
        }

        Text limitTo(Number numberOfLines) {
            return this.newText(this.lines.subList(0, numberOfLines.intValue()));
        }

        Text cropOneLineFromStartAndEnd() {
            return this.newText(this.lines.subList(1, this.lines.size() - 1));
        }

        Text cropOneLineFromStart() {
            return this.newText(this.lines.subList(1, this.lines.size()));
        }

        Text cropOneLineFromEnd() {
            return this.newText(this.lines.subList(0, this.lines.size() - 1));
        }

        Text includeRegexp(List<Pattern> regexps) {
            List<String> newLines = this.lines.stream().filter(line -> regexps.stream().anyMatch(r -> r.matcher((CharSequence)line).find())).collect(Collectors.toList());
            if (newLines.isEmpty()) {
                throw new IllegalArgumentException("there are no lines matching includeRegexp " + this.renderListOfRegexp(regexps) + this.renderInContent());
            }
            return this.newText(newLines);
        }

        Text excludeRegexp(List<Pattern> regexps) {
            List<String> newLines = this.lines.stream().filter(line -> regexps.stream().noneMatch(r -> r.matcher((CharSequence)line).find())).collect(Collectors.toList());
            if (newLines.size() == this.lines.size()) {
                throw new IllegalArgumentException("there are no lines matching excludeRegexp " + this.renderListOfRegexp(regexps) + this.renderInContent());
            }
            return this.newText(newLines);
        }

        private Text newText(List<String> lines) {
            return new Text(this.contentId, lines, false);
        }

        private Text newText(List<String> lines, boolean hasCroppedStart) {
            return new Text(this.contentId, lines, hasCroppedStart);
        }

        private int findLineIdxContaining(String subLine) {
            int i;
            int n = i = this.hasCroppedStart ? 1 : 0;
            while (i < this.lines.size()) {
                if (this.lines.get(i).contains(subLine)) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException("there is no line containing \"" + subLine + "\"" + this.renderInContent());
        }

        public String toString() {
            return String.join((CharSequence)"\n", this.lines);
        }

        private String renderInContent() {
            return " in <" + this.contentId + ">:\n" + this;
        }

        private String renderListOfRegexp(List<Pattern> regexps) {
            return regexps.stream().map(p -> "<" + p.toString() + ">").collect(Collectors.joining(", "));
        }
    }
}

