/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.svg;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.structure.DocStructure;

public class SvgIncludePlugin
implements IncludePlugin {
    private AuxiliaryFile svgAuxiliaryFile;

    @Override
    public String id() {
        return "svg";
    }

    @Override
    public IncludePlugin create() {
        return new SvgIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        DocStructure docStructure = componentsRegistry.docStructure();
        String svgSrc = pluginParams.getFreeParam();
        this.svgAuxiliaryFile = resourcesResolver.runtimeAuxiliaryFile(svgSrc);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("svgSrc", docStructure.fullUrl(this.svgAuxiliaryFile.getDeployRelativePath().toString()) + "?timestamp=" + this.timestamp());
        props.putAll(pluginParams.getOpts().toMap());
        return PluginResult.docElement("Svg", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(this.svgAuxiliaryFile);
    }

    private long timestamp() {
        try {
            return Files.getLastModifiedTime(this.svgAuxiliaryFile.getPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

