/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.html.RenderSupplier;
import org.testingisdocumenting.znai.utils.ResourceUtils;
import org.testingisdocumenting.znai.website.WebResource;

public class HtmlPage {
    public static final String FAVICON_PATH = "favicon.png";
    private final String customFavIconPath;
    private String title;
    private final List<WebResource> cssResources;
    private final List<WebResource> javaScriptResources;
    private final List<RenderSupplier> headSuppliers;
    private final List<RenderSupplier> bodySuppliers;
    private final List<RenderSupplier> javaScriptSuppliers;
    private static final String themeCode = ResourceUtils.textContent("znai-theme.js");

    public HtmlPage() {
        this("");
    }

    public HtmlPage(String customFavIconPath) {
        this.customFavIconPath = customFavIconPath;
        this.title = "";
        this.cssResources = new ArrayList<WebResource>();
        this.javaScriptResources = new ArrayList<WebResource>();
        this.headSuppliers = new ArrayList<RenderSupplier>();
        this.bodySuppliers = new ArrayList<RenderSupplier>();
        this.javaScriptSuppliers = new ArrayList<RenderSupplier>();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addCss(WebResource webResource) {
        this.cssResources.add(webResource);
    }

    public void addJavaScript(WebResource webResource) {
        this.javaScriptResources.add(webResource);
    }

    public void addJavaScriptInFront(WebResource webResource) {
        this.javaScriptResources.add(0, webResource);
    }

    public void addToHead(RenderSupplier supplier) {
        this.headSuppliers.add(supplier);
    }

    public void addToBody(RenderSupplier supplier) {
        this.bodySuppliers.add(supplier);
    }

    public void addToJavaScript(RenderSupplier supplier) {
        this.javaScriptSuppliers.add(supplier);
    }

    public String render(String documentationId) {
        return "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\" /> \n<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, viewport-fit=cover\"> \n<title>" + this.title + "</title>\n" + this.headSuppliers.stream().map(RenderSupplier::render).collect(Collectors.joining("\n")) + this.cssResources.stream().map(r -> r.generateCssLink(documentationId)).collect(Collectors.joining("\n")) + "\n</head>\n<link rel=\"shortcut icon\" href=" + this.favIconPath(documentationId) + "type=\"image/ico\"/>\n<body class=\"theme-znai-dark\">\n<script>" + themeCode + "</script>\n" + this.bodySuppliers.stream().map(RenderSupplier::render).collect(Collectors.joining("\n")) + "\n" + this.javaScriptResources.stream().map(r -> r.generateJavaScriptLink(documentationId)).collect(Collectors.joining("\n")) + "\n<script>\n" + this.javaScriptSuppliers.stream().map(RenderSupplier::render).collect(Collectors.joining("\n")) + "\n</script>\n\n</body>\n</html>\n";
    }

    private String favIconPath(String documentationId) {
        if (!this.customFavIconPath.isEmpty()) {
            return this.makeIconPath(this.customFavIconPath);
        }
        return documentationId.isEmpty() ? this.makeIconPath("/favicon.png") : this.makeIconPath("/" + documentationId + "/" + FAVICON_PATH);
    }

    private String makeIconPath(String path) {
        return "\"" + path + "\"";
    }
}

