/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.java.parser.JavaMethod;
import org.testingisdocumenting.znai.java.parser.JavaMethodReturn;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class JavaDocParamsIncludePlugin
extends JavaIncludePluginBase {
    @Override
    public String id() {
        return "java-doc-params";
    }

    @Override
    public IncludePlugin create() {
        return new JavaDocParamsIncludePlugin();
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        JavaMethod javaMethod = javaCode.findMethod(this.entry);
        ApiParameters apiParameters = new ApiParameters(javaMethod.getAnchorPrefix());
        this.addReturn(apiParameters, javaMethod);
        javaMethod.getParams().forEach(param -> {
            JavaIncludePluginBase.JavaDocElementsMapsAndSearchText docElementsMapsAndSearchText = this.javaDocTextToDocElements(param.getJavaDocText());
            apiParameters.add(param.getName(), new ApiLinkedText(param.getType()), docElementsMapsAndSearchText.docElementsMaps, docElementsMapsAndSearchText.searchText);
        });
        Map<String, Object> props = apiParameters.toMap();
        this.codeReferencesFeature.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List<DocElement> docElements = PluginResult.docElement("ApiParameters", props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaMethod));
    }

    private String extractText(JavaMethod javaMethod) {
        JavaMethodReturn methodReturn = javaMethod.getJavaMethodReturn();
        String returnPart = methodReturn != null ? "return " + methodReturn.getType() + " " + methodReturn.getJavaDocText() : "";
        String paramsPart = javaMethod.getParams().stream().map(p -> p.getName() + " " + p.getType() + " " + p.getJavaDocText()).collect(Collectors.joining(" "));
        return paramsPart + (returnPart.isEmpty() ? "" : " ") + returnPart;
    }

    private void addReturn(ApiParameters apiParameters, JavaMethod javaMethod) {
        JavaMethodReturn methodReturn = javaMethod.getJavaMethodReturn();
        if (methodReturn == null) {
            return;
        }
        JavaIncludePluginBase.JavaDocElementsMapsAndSearchText elementsMapsAndSearchText = this.javaDocTextToDocElements(methodReturn.getJavaDocText());
        apiParameters.add("return", new ApiLinkedText(methodReturn.getType()), elementsMapsAndSearchText.docElementsMaps, elementsMapsAndSearchText.searchText);
    }
}

