/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.table;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.parser.table.Row;
import znaishaded.org.apache.commons.csv.CSVFormat;
import znaishaded.org.apache.commons.csv.CSVParser;
import znaishaded.org.apache.commons.csv.CSVRecord;

public class CsvTableParser {
    private CsvTableParser() {
    }

    public static MarkupTableData parse(String content) {
        return CsvTableParser.parse(content, Collections.emptyList());
    }

    public static MarkupTableData parseWithHeader(String content, String ... header) {
        return CsvTableParser.parse(content, Arrays.asList(header));
    }

    private static MarkupTableData parse(String content, List<String> header) {
        try {
            MarkupTableData tableData = new MarkupTableData();
            CSVFormat csvFormat = CSVFormat.RFC4180;
            if (header.isEmpty()) {
                csvFormat = csvFormat.withFirstRecordAsHeader();
            }
            CSVParser csvRecords = csvFormat.withIgnoreSurroundingSpaces().withIgnoreEmptyLines().withTrim().withDelimiter(',').parse(new StringReader(content));
            List<String> headerToUse = header.isEmpty() ? csvRecords.getHeaderMap().keySet() : header;
            headerToUse.forEach(tableData::addColumn);
            for (CSVRecord record : csvRecords) {
                Row row = new Row();
                record.forEach(row::add);
                if (record.size() != headerToUse.size()) {
                    throw new RuntimeException("record mismatches header. header: " + headerToUse + "; record: " + row.getData());
                }
                tableData.addRow(row);
            }
            return tableData;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

