/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FileUtils {
    private FileUtils() {
    }

    public static void writeTextContent(Path path, String text) {
        try {
            Path parent = path.toAbsolutePath().getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(path, text.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fileTextContent(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException(path.toAbsolutePath() + " doesn't exist");
        }
        try {
            return Files.lines(path).collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] fileBinaryContent(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeException(path.toAbsolutePath() + " doesn't exist");
        }
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileTime getLastModifiedTime(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path existingPathOrThrow(Path ... paths) {
        List nonNull = Arrays.stream(paths).filter(Objects::nonNull).collect(Collectors.toList());
        return nonNull.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new RuntimeException("can't find any of the following files:\n" + nonNull.stream().map(Path::toString).collect(Collectors.joining("\n"))));
    }

    public static void symlinkAwareCreateDirs(Path path) {
        try {
            Path dir = Files.isSymbolicLink(path) ? Files.readSymbolicLink(path) : path;
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(Path source, Path target) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

