/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.Unpooled;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.handler.codec.http.HttpHeaderNames;
import znaishaded.io.netty.handler.codec.http.HttpResponseStatus;
import znaishaded.io.netty.handler.codec.http.HttpStatusClass;
import znaishaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import znaishaded.io.netty.handler.codec.http2.Http2Headers;
import znaishaded.io.vertx.codegen.annotations.Nullable;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.file.AsyncFile;
import znaishaded.io.vertx.core.file.FileSystem;
import znaishaded.io.vertx.core.file.OpenOptions;
import znaishaded.io.vertx.core.http.Cookie;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.http.StreamPriority;
import znaishaded.io.vertx.core.http.StreamResetException;
import znaishaded.io.vertx.core.http.impl.CookieImpl;
import znaishaded.io.vertx.core.http.impl.Http2HeadersAdaptor;
import znaishaded.io.vertx.core.http.impl.Http2ServerConnection;
import znaishaded.io.vertx.core.http.impl.Http2ServerStream;
import znaishaded.io.vertx.core.http.impl.MimeMapping;
import znaishaded.io.vertx.core.http.impl.ServerCookie;
import znaishaded.io.vertx.core.impl.ContextInternal;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;

public class Http2ServerResponseImpl
implements HttpServerResponse {
    private static final Logger log = LoggerFactory.getLogger(Http2ServerResponseImpl.class);
    private final Http2ServerStream stream;
    private final ChannelHandlerContext ctx;
    private final Http2ServerConnection conn;
    private final boolean head;
    private final boolean push;
    private final String host;
    private final Http2Headers headers = new DefaultHttp2Headers();
    private Http2HeadersAdaptor headersMap;
    private Http2Headers trailers;
    private Http2HeadersAdaptor trailedMap;
    private boolean chunked;
    private boolean headWritten;
    private boolean ended;
    private boolean closed;
    private Map<String, ServerCookie> cookies;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private String statusMessage;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private NetSocket netSocket;

    public Http2ServerResponseImpl(Http2ServerConnection conn, Http2ServerStream stream, HttpMethod method, boolean push, String contentEncoding, String host) {
        this.stream = stream;
        this.ctx = conn.handlerContext;
        this.conn = conn;
        this.head = method == HttpMethod.HEAD;
        this.push = push;
        this.host = host;
        if (contentEncoding != null) {
            this.putHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (CharSequence)contentEncoding);
        }
    }

    boolean isPush() {
        return this.push;
    }

    void handleReset(long code) {
        this.handleException(new StreamResetException(code));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable cause) {
        Handler<Throwable> handler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            handler = this.exceptionHandler;
        }
        if (handler != null) {
            handler.handle(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClose() {
        Handler<Void> closeHandler;
        Handler<Void> endHandler;
        Handler<Throwable> exceptionHandler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            boolean failed = !this.ended;
            this.closed = true;
            exceptionHandler = failed ? this.exceptionHandler : null;
            endHandler = failed ? this.endHandler : null;
            closeHandler = this.closeHandler;
        }
        if (exceptionHandler != null) {
            exceptionHandler.handle(ConnectionBase.CLOSED_EXCEPTION);
        }
        if (endHandler != null) {
            endHandler.handle(null);
        }
        if (closeHandler != null) {
            closeHandler.handle(null);
        }
    }

    private void checkHeadWritten() {
        if (this.headWritten) {
            throw new IllegalStateException("Header already sent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStatusCode() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.status.code();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        if (statusCode < 0) {
            throw new IllegalArgumentException("code: " + statusCode + " (expected: 0+)");
        }
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.status = HttpResponseStatus.valueOf(statusCode);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatusMessage() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.statusMessage == null) {
                return this.status.reasonPhrase();
            }
            return this.statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.statusMessage = statusMessage;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setChunked(boolean chunked) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.chunked = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.chunked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap headers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.headersMap == null) {
                this.headersMap = new Http2HeadersAdaptor(this.headers);
            }
            return this.headersMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiMap trailers() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.trailedMap == null) {
                this.trailers = new DefaultHttp2Headers();
                this.trailedMap = new Http2HeadersAdaptor(this.trailers);
            }
            return this.trailedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, String value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.endHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse writeContinue() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkHeadWritten();
            this.stream.writeHeaders(new DefaultHttp2Headers().status("100"), false, null);
            return this;
        }
    }

    @Override
    public HttpServerResponse write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false, null);
        return this;
    }

    @Override
    public HttpServerResponse write(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        ByteBuf buf = chunk.getByteBuf();
        this.write(buf, false, handler);
        return this;
    }

    @Override
    public HttpServerResponse write(String chunk, String enc) {
        return this.write(Buffer.buffer(chunk, enc).getByteBuf());
    }

    @Override
    public HttpServerResponse write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk, enc).getByteBuf(), false, handler);
        return this;
    }

    @Override
    public HttpServerResponse write(String chunk) {
        return this.write(Buffer.buffer(chunk).getByteBuf());
    }

    @Override
    public HttpServerResponse write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.write(Buffer.buffer(chunk).getByteBuf(), false, handler);
        return this;
    }

    private Http2ServerResponseImpl write(ByteBuf chunk) {
        this.write(chunk, false, null);
        return this;
    }

    @Override
    public void end(String chunk) {
        this.end(Buffer.buffer(chunk));
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk), handler);
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.end(Buffer.buffer(chunk, enc));
    }

    @Override
    public void end(Buffer chunk) {
        this.end(chunk.getByteBuf(), (Handler<AsyncResult<Void>>)null);
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        this.end(chunk.getByteBuf(), handler);
    }

    @Override
    public void end() {
        this.end((ByteBuf)null, (Handler<AsyncResult<Void>>)null);
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        this.end((ByteBuf)null, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NetSocket netSocket() {
        this.checkValid();
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.netSocket != null) {
                return this.netSocket;
            }
            this.status = HttpResponseStatus.OK;
            if (!this.checkSendHeaders(false)) {
                throw new IllegalStateException("Response for CONNECT already sent");
            }
            this.ctx.flush();
            this.netSocket = this.conn.toNetSocket(this.stream);
        }
        return this.netSocket;
    }

    @Override
    private void end(ByteBuf chunk, Handler<AsyncResult<Void>> handler) {
        this.write(chunk, true, handler);
    }

    private void sanitizeHeaders() {
        if (this.head || this.status == HttpResponseStatus.NOT_MODIFIED) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
        } else if (this.status == HttpResponseStatus.RESET_CONTENT) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
            this.headers.set(HttpHeaders.CONTENT_LENGTH, "0");
        } else if (this.status.codeClass() == HttpStatusClass.INFORMATIONAL || this.status == HttpResponseStatus.NO_CONTENT) {
            this.headers.remove(HttpHeaders.TRANSFER_ENCODING);
            this.headers.remove(HttpHeaders.CONTENT_LENGTH);
        }
    }

    private boolean checkSendHeaders(boolean end) {
        if (!this.headWritten) {
            if (this.headersEndHandler != null) {
                this.headersEndHandler.handle(null);
            }
            if (this.cookies != null) {
                this.setCookies();
            }
            this.sanitizeHeaders();
            this.headWritten = true;
            this.headers.status(Integer.toString(this.status.code()));
            this.stream.writeHead(this.headers, end, null);
            if (end) {
                this.ctx.flush();
            }
            return true;
        }
        return false;
    }

    private void setCookies() {
        for (ServerCookie cookie : this.cookies.values()) {
            if (!cookie.isChanged()) continue;
            this.headers.add(HttpHeaders.SET_COOKIE, cookie.encode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
        Handler<Void> endHandler;
        Handler<Void> bodyEndHandler;
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.ended) {
                throw new IllegalStateException("Response has already been written");
            }
            this.ended |= end;
            boolean hasBody = false;
            if (chunk != null) {
                hasBody = true;
            } else {
                chunk = Unpooled.EMPTY_BUFFER;
            }
            if (end && !this.headWritten && !this.head && this.status != HttpResponseStatus.NOT_MODIFIED && !this.headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                this.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.readableBytes()));
            }
            boolean sent = this.checkSendHeaders(end && !hasBody && this.trailers == null);
            if (hasBody || !sent && end) {
                this.stream.writeData(chunk, end && this.trailers == null, handler);
            }
            if (end && this.trailers != null) {
                this.stream.writeHeaders(this.trailers, true, null);
            }
            bodyEndHandler = this.bodyEndHandler;
            endHandler = this.endHandler;
        }
        if (end) {
            if (bodyEndHandler != null) {
                bodyEndHandler.handle(null);
            }
            if (endHandler != null) {
                endHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse writeCustomFrame(int type, int flags, Buffer payload) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            this.checkSendHeaders(false);
            this.stream.writeFrame(type, flags, payload.getByteBuf());
            this.ctx.flush();
            return this;
        }
    }

    private void checkValid() {
        if (this.ended) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    void writabilityChanged() {
        if (!this.ended && !this.writeQueueFull() && this.drainHandler != null) {
            this.drainHandler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
            return this.stream.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.checkValid();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (handler != null) {
                this.checkValid();
            }
            this.drainHandler = handler;
            return this;
        }
    }

    @Override
    public HttpServerResponse sendFile(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            Handler<AsyncResult> h2;
            this.checkValid();
            if (resultHandler != null) {
                ContextInternal resultCtx = this.stream.vertx.getOrCreateContext();
                h2 = ar -> resultCtx.runOnContext(v -> resultHandler.handle((AsyncResult<Void>)ar));
            } else {
                h2 = ar -> {};
            }
            File file_ = this.stream.vertx.resolveFile(filename);
            if (!file_.exists()) {
                if (resultHandler != null) {
                    h2.handle(Future.failedFuture(new FileNotFoundException()));
                } else {
                    log.error("File not found: " + filename);
                }
                return this;
            }
            try {
                RandomAccessFile raf = new RandomAccessFile(file_, "r");
                Throwable throwable = null;
                if (raf != null) {
                    if (throwable != null) {
                        try {
                            raf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        raf.close();
                    }
                }
            }
            catch (IOException e) {
                if (resultHandler != null) {
                    h2.handle(Future.failedFuture(e));
                } else {
                    log.error((Object)"Failed to send file", e);
                }
                return this;
            }
            long contentLength = Math.min(length, file_.length() - offset);
            FileSystem fs = this.conn.vertx().fileSystem();
            fs.open(filename, new OpenOptions().setCreate(false).setWrite(false), ar -> {
                if (ar.succeeded()) {
                    String contentType;
                    AsyncFile file = (AsyncFile)ar.result();
                    if (this.headers.get(HttpHeaderNames.CONTENT_LENGTH) == null) {
                        this.putHeader((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(contentLength));
                    }
                    if (this.headers.get(HttpHeaderNames.CONTENT_TYPE) == null && (contentType = MimeMapping.getMimeTypeForFilename(filename)) != null) {
                        this.putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)contentType);
                    }
                    this.checkSendHeaders(false);
                    file.setReadPos(offset);
                    file.setReadLength(contentLength);
                    file.pipeTo(this, ar1 -> file.close(ar2 -> {
                        Throwable failure;
                        Throwable throwable = ar1.failed() ? ar1.cause() : (failure = ar2.failed() ? ar2.cause() : null);
                        if (failure == null) {
                            h2.handle((AsyncResult)ar1);
                        } else {
                            h2.handle(Future.failedFuture(failure));
                        }
                    }));
                } else {
                    h2.handle(ar.mapEmpty());
                }
            });
        }
        return this;
    }

    @Override
    public void close() {
        this.conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.ended;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closed() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(@Nullable Handler<Void> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    @Override
    public long bytesWritten() {
        return this.stream.bytesWritten();
    }

    @Override
    public int streamId() {
        return this.stream.id();
    }

    @Override
    public void reset(long code) {
        this.checkValid();
        this.stream.writeReset(code);
        this.ctx.flush();
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, host, path, null, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, null, path, headers, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        Http2ServerConnection http2ServerConnection = this.conn;
        synchronized (http2ServerConnection) {
            if (this.push) {
                throw new IllegalStateException("A push response cannot promise another push");
            }
            this.checkValid();
            this.conn.sendPush(this.stream.id(), host, method, headers, path, this.stream.priority(), handler);
            return this;
        }
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, this.host, path, handler);
    }

    @Override
    public HttpServerResponse setStreamPriority(StreamPriority priority) {
        this.stream.updatePriority(priority);
        return this;
    }

    Map<String, ServerCookie> cookies() {
        if (this.cookies == null) {
            this.cookies = CookieImpl.extractCookies(this.stream.headers != null ? (CharSequence)this.stream.headers.get(HttpHeaders.COOKIE) : null);
        }
        return this.cookies;
    }

    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        this.cookies().put(cookie.getName(), (ServerCookie)cookie);
        return this;
    }

    @Override
    public @Nullable Cookie removeCookie(String name, boolean invalidate) {
        return CookieImpl.removeCookie(this.cookies(), name, invalidate);
    }
}

