/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.File;
import java.io.PrintStream;
import znaishaded.net.sourceforge.plantuml.ErrorStatus;
import znaishaded.net.sourceforge.plantuml.ErrorUml;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.Stdrpt;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.eggs.PSystemWelcome;
import znaishaded.net.sourceforge.plantuml.error.PSystemError;

public class StdrptV1
implements Stdrpt {
    @Override
    public void printInfo(PrintStream output, Diagram sys) {
        if (sys instanceof PSystemWelcome) {
            sys = null;
        }
        if (sys == null || sys instanceof PSystemError) {
            this.out(output, (PSystemError)sys);
        }
    }

    @Override
    public void errorLine(int lineError, File file) {
        Log.error("Error line " + lineError + " in file: " + file.getPath());
    }

    private void out(PrintStream output, PSystemError err) {
        output.println("protocolVersion=1");
        if (this.empty(err)) {
            output.println("status=NO_DATA");
        } else {
            output.println("status=ERROR");
            output.println("lineNumber=" + err.getLineLocation().getPosition());
            for (ErrorUml er : err.getErrorsUml()) {
                output.println("label=" + er.getError());
            }
        }
        output.flush();
    }

    private boolean empty(PSystemError err) {
        if (err == null) {
            return true;
        }
        for (ErrorUml er : err.getErrorsUml()) {
            if (!"Empty description".equals(er.getError())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void finalMessage(ErrorStatus error) {
        if (error.hasError()) {
            Log.error("Some diagram description contains errors");
        }
        if (error.isNoData()) {
            Log.error("No diagram found");
        }
    }
}

