/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final Colors colors;
    private final LinkRendering inlinkRendering;
    private final BoxStyle style;
    private final Url url;

    @Override
    public boolean containsBreak() {
        return false;
    }

    public InstructionSimple(Display label, LinkRendering inlinkRendering, Swimlane swimlane, BoxStyle style, Url url, Colors colors) {
        super(swimlane);
        if (colors == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.style = style;
        this.label = label;
        this.inlinkRendering = inlinkRendering;
        if (inlinkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.colors = colors;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile result = factory.activity(this.label, this.getSwimlaneIn(), this.style, this.colors);
        if (this.url != null) {
            result = factory.addUrl(result, this.url);
        }
        result = this.eventuallyAddNote(factory, result, result.getSwimlaneIn());
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    @Override
    public void add(Instruction other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean kill() {
        this.killed = true;
        return true;
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }
}

