/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.command;

import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class CommandPartition3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandPartition3() {
        super(CommandPartition3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPartition3.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(partition|package|rectangle|card)"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexConcat(CommandPartition3.color("BACK1").getRegex(), RegexLeaf.spaceOneOrMore())), new RegexLeaf("NAME", "([%g][^%g]+[%g]|\\S+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), CommandPartition3.color("BACK2").getRegex())), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{?"), RegexLeaf.end());
    }

    private USymbol getUSymbol(String type) {
        if ("card".equalsIgnoreCase(type)) {
            return USymbol.CARD;
        }
        if ("package".equalsIgnoreCase(type)) {
            return USymbol.PACKAGE;
        }
        if ("rectangle".equalsIgnoreCase(type)) {
            return USymbol.RECTANGLE;
        }
        return USymbol.FRAME;
    }

    private ColorParam getColorParamBorder(USymbol symbol) {
        if (symbol == USymbol.FRAME) {
            return ColorParam.partitionBorder;
        }
        return symbol.getColorParamBorder();
    }

    private ColorParam getColorParamBack(USymbol symbol) {
        if (symbol == USymbol.FRAME) {
            return ColorParam.partitionBackground;
        }
        return symbol.getColorParamBack();
    }

    private static ColorParser color(String id) {
        return ColorParser.simpleColor(ColorType.BACK, id);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg) {
        String partitionTitle = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("NAME", 0));
        String b1 = arg.get("BACK1", 0);
        Colors colors = CommandPartition3.color(b1 == null ? "BACK2" : "BACK1").getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        USymbol symbol = this.getUSymbol(arg.get("TYPE", 0));
        String stereo = arg.get("STEREO", 0);
        Stereotype stereotype = stereo == null ? null : new Stereotype(stereo);
        HColor backColorInSkinparam = diagram.getSkinParam().getHtmlColor(this.getColorParamBack(symbol), stereotype, false);
        HColor backColor = backColorInSkinparam == null ? colors.getColor(ColorType.BACK) : backColorInSkinparam;
        HColor titleColor = colors.getColor(ColorType.HEADER);
        HColor borderColor = diagram.getSkinParam().getHtmlColor(this.getColorParamBorder(symbol), stereotype, false);
        if (borderColor == null) {
            borderColor = HColorUtils.BLACK;
        }
        double roundCorner = symbol.getSkinParameter().getRoundCorner(diagram.getSkinParam(), stereotype);
        if (SkinParam.USE_STYLES()) {
            Style stylePartition = this.getDefaultStyleDefinitionPartition().getMergedStyle(diagram.getSkinParam().getCurrentStyleBuilder());
            borderColor = stylePartition.value(PName.LineColor).asColor(diagram.getSkinParam().getIHtmlColorSet());
            backColor = colors.getColor(ColorType.BACK);
            if (backColor == null) {
                backColor = stylePartition.value(PName.BackGroundColor).asColor(diagram.getSkinParam().getIHtmlColorSet());
            }
            titleColor = HColorUtils.BLUE;
            roundCorner = stylePartition.value(PName.RoundCorner).asDouble();
        }
        diagram.startGroup(Display.getWithNewlines(partitionTitle), backColor, titleColor, borderColor, symbol, roundCorner);
        return CommandExecutionResult.ok();
    }

    public final StyleSignature getDefaultStyleDefinitionPartition() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.partition);
    }
}

