/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.AsciiShape;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextActor
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final AsciiShape shape;

    public ComponentTextActor(ComponentType type, Display stringsToDisplay, FileFormat fileFormat, AsciiShape shape) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
        this.shape = shape;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        charArea.fillRect(' ', 0, 0, width, height);
        int xman = width / 2 - 1;
        if (this.type == ComponentType.ACTOR_HEAD) {
            charArea.drawStringsLR(this.stringsToDisplay.as(), 1, this.getHeight());
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawShape(AsciiShape.STICKMAN_UNICODE, xman, 0);
            } else {
                charArea.drawShape(AsciiShape.STICKMAN, xman, 0);
            }
        } else if (this.type == ComponentType.ACTOR_TAIL) {
            charArea.drawStringsLR(this.stringsToDisplay.as(), 1, 0);
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawShape(AsciiShape.STICKMAN_UNICODE, xman, 1);
            } else {
                charArea.drawShape(AsciiShape.STICKMAN, xman, 1);
            }
        } else assert (false);
    }

    private int getHeight() {
        if (this.fileFormat == FileFormat.UTXT) {
            return AsciiShape.STICKMAN_UNICODE.getHeight();
        }
        return AsciiShape.STICKMAN.getHeight();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + this.getHeight();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 2;
    }
}

