/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.LineLocation;
import znaishaded.net.sourceforge.plantuml.StringLocated;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class BlocLines
implements Iterable<StringLocated> {
    private List<StringLocated> lines;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated line : this.lines) {
            sb.append("<<<");
            sb.append(line);
            sb.append(">>>");
        }
        return sb.toString();
    }

    public static BlocLines load(SFile f, LineLocation location) throws IOException {
        BufferedReader br = f.openBufferedReader();
        if (br == null) {
            return null;
        }
        return BlocLines.loadInternal(br, location);
    }

    public static BlocLines load(InputStream is, LineLocation location) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return BlocLines.loadInternal(br, location);
    }

    private static BlocLines loadInternal(BufferedReader br, LineLocation location) throws IOException {
        String s2;
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        while ((s2 = br.readLine()) != null) {
            result.add(new StringLocated(s2, location));
        }
        br.close();
        return new BlocLines(result);
    }

    private BlocLines(List<StringLocated> lines) {
        this.lines = Collections.unmodifiableList(lines);
    }

    public Display toDisplay() {
        return Display.createFoo(this.lines);
    }

    public static BlocLines single(StringLocated single) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        result.add(single);
        return new BlocLines(result);
    }

    public static BlocLines singleString(String single) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        result.add(new StringLocated(single, null));
        return new BlocLines(result);
    }

    public static BlocLines fromArray(String[] array) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        for (String single : array) {
            result.add(new StringLocated(single, null));
        }
        return new BlocLines(result);
    }

    public static BlocLines getWithNewlines(String s2) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        for (String cs : BackSlash.getWithNewlines(s2)) {
            result.add(new StringLocated(cs, null));
        }
        return new BlocLines(result);
    }

    public BlocLines() {
        this(new ArrayList<StringLocated>());
    }

    public BlocLines add(StringLocated s2) {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy.add(s2);
        return new BlocLines(copy);
    }

    public BlocLines addString(String s2) {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy.add(new StringLocated(s2, null));
        return new BlocLines(copy);
    }

    public List<String> getLinesAsStringForSprite() {
        ArrayList<String> result = new ArrayList<String>();
        for (StringLocated s2 : this.lines) {
            result.add(s2.getString());
        }
        return result;
    }

    public int size() {
        return this.lines.size();
    }

    public StringLocated getAt(int i) {
        return this.lines.get(i);
    }

    public StringLocated getFirst() {
        if (this.lines.size() == 0) {
            return null;
        }
        return this.lines.get(0);
    }

    public StringLocated getLast() {
        return this.lines.get(this.lines.size() - 1);
    }

    public BlocLines cleanList(MultilinesStrategy strategy) {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        strategy.cleanList(copy);
        return new BlocLines(copy);
    }

    public BlocLines trim() {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        for (int i = 0; i < copy.size(); ++i) {
            StringLocated s2 = (StringLocated)copy.get(i);
            copy.set(i, s2.getTrimmed());
        }
        return new BlocLines(copy);
    }

    public BlocLines removeEmptyLines() {
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            if (((StringLocated)it.next()).getString().length() != 0) continue;
            it.remove();
        }
        return new BlocLines(copy);
    }

    public BlocLines removeEmptyColumns() {
        if (!BlocLines.firstColumnRemovable(this.lines)) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        do {
            for (int i = 0; i < copy.size(); ++i) {
                StringLocated s2 = (StringLocated)copy.get(i);
                if (s2.getString().length() <= 0) continue;
                copy.set(i, s2.substring(1, s2.getString().length()));
            }
        } while (BlocLines.firstColumnRemovable(copy));
        return new BlocLines(copy);
    }

    private static boolean firstColumnRemovable(List<StringLocated> data) {
        boolean allEmpty = true;
        for (StringLocated s2 : data) {
            if (s2.getString().length() == 0) continue;
            allEmpty = false;
            char c = s2.getString().charAt(0);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return !allEmpty;
    }

    public char getLastChar() {
        StringLocated s2 = this.lines.get(this.lines.size() - 1);
        return s2.getString().charAt(s2.getString().length() - 1);
    }

    public BlocLines removeStartingAndEnding(String data, int removeAtEnd) {
        if (this.lines.size() == 0) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy.set(0, new StringLocated(data, null));
        int n = copy.size() - 1;
        StringLocated s2 = (StringLocated)copy.get(n);
        copy.set(n, s2.substring(0, s2.getString().length() - removeAtEnd));
        return new BlocLines(copy);
    }

    public BlocLines overrideLastLine(String last) {
        if (this.lines.size() == 0) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        int n = copy.size() - 1;
        StringLocated currentLast = (StringLocated)copy.get(n);
        copy.set(n, new StringLocated(last, currentLast.getLocation()));
        return new BlocLines(copy);
    }

    public BlocLines toSingleLineWithHiddenNewLine() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated line : this.lines) {
            sb.append(line.getString());
            sb.append(BackSlash.hiddenNewLine());
        }
        return BlocLines.singleString(sb.substring(0, sb.length() - 1).toString());
    }

    public BlocLines trimSmart(int referenceLine) {
        if (this.lines.size() <= referenceLine) {
            return this;
        }
        ArrayList<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        int nbStartingSpace = BlocLines.nbStartingSpace(((StringLocated)copy.get(referenceLine)).getString());
        for (int i = referenceLine; i < copy.size(); ++i) {
            StringLocated s2 = (StringLocated)copy.get(i);
            copy.set(i, BlocLines.removeStartingSpaces(s2, nbStartingSpace));
        }
        return new BlocLines(copy);
    }

    private static int nbStartingSpace(CharSequence s2) {
        int nb;
        for (nb = 0; nb < s2.length() && BlocLines.isSpaceOrTab(s2.charAt(nb)); ++nb) {
        }
        return nb;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private static StringLocated removeStartingSpaces(StringLocated arg, int nbStartingSpace) {
        int i;
        if (arg.getString().length() == 0) {
            return arg;
        }
        for (i = 0; i < nbStartingSpace && i < arg.getString().length() && BlocLines.isSpaceOrTab(arg.getString().charAt(i)); ++i) {
        }
        if (i == 0) {
            return arg;
        }
        return arg.substring(i, arg.getString().length());
    }

    public BlocLines subExtract(int margeStart, int margeEnd) {
        List<StringLocated> copy = new ArrayList<StringLocated>(this.lines);
        copy = copy.subList(margeStart, copy.size() - margeEnd);
        return new BlocLines(copy);
    }

    public BlocLines subList(int start, int end) {
        return new BlocLines(this.lines.subList(start, end));
    }

    @Override
    public Iterator<StringLocated> iterator() {
        return this.lines.iterator();
    }

    public BlocLines eventuallyMoveBracket() {
        if (this.size() < 2) {
            return this;
        }
        String first = this.getFirst().getTrimmed().getString();
        String second = this.getAt(1).getTrimmed().getString();
        if (!first.endsWith("{") && second.equals("{")) {
            StringLocated vline = this.getFirst().append(" {");
            ArrayList<StringLocated> result = new ArrayList<StringLocated>();
            result.add(vline);
            result.addAll(this.lines.subList(2, this.lines.size()));
            return new BlocLines(result);
        }
        return this;
    }

    public BlocLines eventuallyMoveAllEmptyBracket() {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        for (StringLocated line : this.lines) {
            if (line.getTrimmed().toString().equals("{")) {
                if (result.size() <= 0) continue;
                int pos = result.size() - 1;
                StringLocated last = (StringLocated)result.get(pos);
                result.set(pos, last.append(" {"));
                continue;
            }
            result.add(line);
        }
        return new BlocLines(result);
    }
}

