/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.hector;

import java.awt.geom.Point2D;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentDouble;
import znaishaded.net.sourceforge.plantuml.hector.Box2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

class SmartConnection {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;
    private final List<Box2D> forbidden;

    public SmartConnection(double x1, double y1, double x2, double y2, List<Box2D> forbidden) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.forbidden = forbidden;
    }

    public SmartConnection(Point2D p1, Point2D p2, List<Box2D> b) {
        this(p1.getX(), p1.getY(), p2.getX(), p2.getY(), b);
    }

    public void draw(UGraphic ug, HColor color) {
        LineSegmentDouble seg = new LineSegmentDouble(this.x1, this.y1, this.x2, this.y2);
        boolean clash = this.intersect(seg);
        ug = clash ? ug.apply(HColorUtils.BLACK).apply(new UStroke(1.0)) : ug.apply(color).apply(new UStroke(1.5));
        seg.draw(ug);
    }

    private boolean intersect(LineSegmentDouble seg) {
        for (Box2D box : this.forbidden) {
            if (!box.doesIntersect(seg)) continue;
            return true;
        }
        return false;
    }

    public void drawEx1(UGraphic ug, HColor color) {
        ug = ug.apply(color).apply(new UStroke(1.5));
        double orthoX = -(this.y2 - this.y1);
        double orthoY = this.x2 - this.x1;
        for (int i = -10; i <= 10; ++i) {
            for (int j = -10; j <= 10; ++j) {
                double d1x = orthoX * (double)i / 10.0;
                double d1y = orthoY * (double)i / 10.0;
                double c1x = (this.x1 + this.x2) / 2.0 + d1x;
                double c1y = (this.y1 + this.y2) / 2.0 + d1y;
                double d2x = orthoX * (double)j / 10.0;
                double d2y = orthoY * (double)j / 10.0;
                double c2x = (this.x1 + this.x2) / 2.0 + d2x;
                double c2y = (this.y1 + this.y2) / 2.0 + d2y;
                UPath path = new UPath();
                path.moveTo(this.x1, this.y1);
                path.cubicTo(c1x, c1y, c2x, c2y, this.x2, this.y2);
                ug.draw(path);
            }
        }
    }
}

