/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.png.PngIOMetadata;
import znaishaded.net.sourceforge.plantuml.security.ImageIO;
import znaishaded.net.sourceforge.plantuml.security.SFile;

public class PngIO {
    private static final String copyleft = "Generated by http://plantuml.com";
    public static boolean forceImageIO = false;

    public static void write(RenderedImage image, SFile file, int dpi) throws IOException {
        PngIO.write(image, file, null, dpi);
    }

    public static void write(RenderedImage image, OutputStream os, int dpi) throws IOException {
        PngIO.write(image, os, null, dpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(RenderedImage image, SFile file, String metadata, int dpi) throws IOException {
        try (BufferedOutputStream os = null;){
            os = file.createBufferedOutputStream();
            PngIO.write(image, os, metadata, dpi);
        }
        Log.debug("File is " + file);
        Log.debug("File size " + file.length());
        if (file.length() == 0L) {
            Log.error("File size is zero: " + file);
            ImageIO.write(image, "png", file);
        }
    }

    public static void write(RenderedImage image, OutputStream os, String metadata, int dpi) throws IOException {
        PngIO.write(image, os, metadata, dpi, null);
    }

    public static void write(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        if (!forceImageIO && metadata != null && PngIO.checkPNGMetadata()) {
            PngIOMetadata.writeWithMetadata(image, os, metadata, dpi, debugData);
        } else {
            ImageIO.write(image, "png", os);
        }
    }

    static boolean checkPNGMetadata() {
        try {
            Class<?> cl = Class.forName("com.sun.imageio.plugins.png.PNGMetadata");
            if (cl == null) {
                Log.info("Cannot load com.sun.imageio.plugins.png.PNGMetadata");
                forceImageIO = true;
                return false;
            }
            Log.info("Ok for com.sun.imageio.plugins.png.PNGMetadata");
            return true;
        }
        catch (Exception e) {
            Log.info("Error loading com.sun.imageio.plugins.png.PNGMetadata " + e);
            forceImageIO = true;
            return false;
        }
    }
}

