/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wbs;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBox;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.wbs.WElement;

abstract class WBSTextBlock
extends AbstractTextBlock {
    protected final ISkinParam skinParam;
    private final StyleBuilder styleBuilder;
    private final int level;

    public WBSTextBlock(ISkinParam skinParam, StyleBuilder styleBuilder, int level) {
        this.skinParam = skinParam;
        this.styleBuilder = styleBuilder;
        this.level = level;
    }

    protected final void drawLine(UGraphic ug, Point2D p1, Point2D p2) {
        ULine line = new ULine(p1, p2);
        if (SkinParam.USE_STYLES()) {
            this.getStyleUsed().applyStrokeAndLineColor(ug.apply(new UTranslate(p1)), this.skinParam.getIHtmlColorSet()).draw(line);
        } else {
            HColor color = ColorParam.activityBorder.getDefaultValue();
            ug.apply(new UTranslate(p1)).apply(color).draw(line);
        }
    }

    private Style getStyleUsed() {
        return this.getDefaultStyleDefinitionArrow().getMergedStyle(this.styleBuilder);
    }

    protected final void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        this.drawLine(ug, new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
    }

    public final StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.wbsDiagram, SName.arrow).add(SName.depth(this.level));
    }

    protected final TextBlock buildMain(WElement idea) {
        Display label = idea.getLabel();
        UFont font = this.skinParam.getFont(null, false, FontParam.ACTIVITY);
        if (idea.getShape() == IdeaShape.BOX) {
            FtileBox box = FtileBox.createWbs(idea.getStyle(), this.skinParam, label);
            return box;
        }
        TextBlock text = label.create(FontConfiguration.blackBlueTrue(font), HorizontalAlignment.LEFT, this.skinParam);
        return TextBlockUtils.withMargin(text, 0.0, 3.0, 1.0, 1.0);
    }
}

