/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsTracker;

class PluginsTracker {
    public final Tracker includePlugins = new Tracker();
    public final Tracker fencePlugins = new Tracker();
    public final Tracker inlineCodePlugins = new Tracker();

    PluginsTracker() {
    }

    public Map<String, ?> buildStatsMap() {
        LinkedHashMap result = new LinkedHashMap();
        result.put("includePlugins", this.includePlugins.buildStats());
        result.put("fencePlugins", this.fencePlugins.buildStats());
        result.put("inlineCodePlugins", this.inlineCodePlugins.buildStats());
        return result;
    }

    static class ParamsTracker {
        final Map<String, Boolean> params = new ConcurrentHashMap<String, Boolean>();

        ParamsTracker() {
        }

        public void registerParams(PluginParams pluginParams) {
            pluginParams.getOpts().forEach((paramName, paramValue) -> this.params.put((String)paramName, true));
        }
    }

    static class Tracker {
        private final Map<String, LongAdder> countById = new ConcurrentHashMap<String, LongAdder>();
        private final Map<String, ParamsTracker> paramsTrackerById = new ConcurrentHashMap<String, ParamsTracker>();

        Tracker() {
        }

        public void increment(String pluginId) {
            this.countById.computeIfAbsent(pluginId, k -> new LongAdder()).increment();
        }

        public PluginParamsTracker createParamsTracker(String pluginId) {
            return params -> this.paramsTrackerById.computeIfAbsent(pluginId, k -> new ParamsTracker()).registerParams(params);
        }

        public Map<String, ?> buildStats() {
            return this.countById.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.buildStatsForPlugin((String)e.getKey())));
        }

        private Map<String, ?> buildStatsForPlugin(String pluginId) {
            Set<String> paramNames;
            LinkedHashMap<String, Object> stats = new LinkedHashMap<String, Object>();
            stats.put("count", this.countById.get(pluginId).intValue());
            ParamsTracker paramsTracker = this.paramsTrackerById.get(pluginId);
            if (paramsTracker != null && !(paramNames = paramsTracker.params.keySet()).isEmpty()) {
                stats.put("params", paramNames);
            }
            return stats;
        }
    }
}

